/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.todomvc;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.io.Serializable;
import java.util.function.Predicate;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableObjectValue;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.defaults.DefaultWritable;
import org.genericsystem.defaults.tools.RxJavaHelpers;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.Attribute;
import org.genericsystem.reactor.annotations.BindAction;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.annotations.DependsOnModel;
import org.genericsystem.reactor.annotations.DirectSelect;
import org.genericsystem.reactor.annotations.ForEach;
import org.genericsystem.reactor.annotations.SetText;
import org.genericsystem.reactor.annotations.StyleClass;
import org.genericsystem.reactor.annotations.Switch;
import org.genericsystem.reactor.annotations.TagName;
import org.genericsystem.reactor.appserver.ApplicationServer;
import org.genericsystem.reactor.context.ContextAction;
import org.genericsystem.reactor.context.ForEachExtractor;
import org.genericsystem.reactor.context.TagSwitcher;
import org.genericsystem.reactor.gscomponents.FlexDiv;
import org.genericsystem.reactor.gscomponents.HtmlTag;
import org.genericsystem.reactor.gscomponents.RootTagImpl;
import org.genericsystem.reactor.gscomponents.TagImpl;
import org.genericsystem.todomvc.Todos;

@DependsOnModel(value={Todos.class, Todos.Completed.class})
@Children(value={RootDiv.class})
public class TodoApp
extends RootTagImpl {
    public static final String FILTER_MODE = "mode";
    public static final String COMPLETED = "completed";
    static Predicate<Generic> ALL = o -> true;
    static Predicate<Generic> ACTIVE = completedObs -> completedObs != null ? Boolean.FALSE.equals(completedObs.getValue()) : true;
    static Predicate<Generic> COMPLETE = ACTIVE.negate();
    static Predicate<Generic> completed = todo -> {
        Generic completed = (Generic)todo.getHolder((DefaultGeneric)todo.getRoot().find(Todos.Completed.class), (DefaultGeneric[])new Generic[0]);
        return completed != null && Boolean.TRUE.equals(completed.getValue());
    };

    public static void main(String[] mainArgs) {
        ApplicationServer.startSimpleGenericApp((String[])mainArgs, TodoApp.class, (String)"/todo2/");
    }

    protected static Property<Predicate<Generic>> getModeProperty(Tag tag, Context model) {
        return tag.getContextProperty(FILTER_MODE, model);
    }

    public void init() {
        this.addContextAttribute(FILTER_MODE, c -> new SimpleObjectProperty(ALL));
    }

    protected static Snapshot<Generic> getTodos(Context context) {
        return context.find(Todos.class).getSubInstances();
    }

    protected static Snapshot<Generic> getCompletedTodos(Context context) {
        return context.find(Todos.Completed.class).getSubInstances().filter(comp -> Boolean.TRUE.equals(comp.getValue())).map(comp -> (Generic)comp.getComponent(0));
    }

    @Children(value={ContentDiv.class, MainFooter.class})
    public static class RootDiv
    extends HtmlTag.HtmlDiv {

        @StyleClass.StyleClasses(value={@StyleClass(value={"save-cancel"}), @StyleClass(path={HtmlTag.HtmlButton.class}, pos={0}, value={"save"}), @StyleClass(path={HtmlTag.HtmlButton.class}, pos={1}, value={"cancel"})})
        @Children(value={HtmlTag.HtmlButton.class, HtmlTag.HtmlButton.class})
        @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlButton.class}, pos={0}, value={"Save"}), @SetText(path={HtmlTag.HtmlButton.class}, pos={1}, value={"Cancel"})})
        @BindAction.BindActions(value={@BindAction(path={HtmlTag.HtmlButton.class}, pos={0}, value={ContextAction.FLUSH.class}), @BindAction(path={HtmlTag.HtmlButton.class}, pos={1}, value={ContextAction.CANCEL.class})})
        public static class MainFooter
        extends HtmlTag.HtmlFooter {
        }

        @StyleClass.StyleClasses(value={@StyleClass(value={"todoapp"}), @StyleClass(path={HtmlTag.HtmlHeader.class}, value={"header"})})
        @Children.ChildrenMult(value={@Children(value={HtmlTag.HtmlHeader.class, TodosContent.class, TodosFooter.class}), @Children(path={HtmlTag.HtmlHeader.class}, value={HtmlTag.HtmlH1.class, TodoInput.class})})
        @SetText(path={HtmlTag.HtmlHeader.class, HtmlTag.HtmlH1.class}, value={"todos"})
        public static class ContentDiv
        extends FlexDiv {
            public void init() {
                this.addContextAttribute("removing", context -> new SimpleBooleanProperty(false));
            }

            @StyleClass.StyleClasses(value={@StyleClass(value={"footer"}), @StyleClass(path={HtmlTag.HtmlDiv.class, HtmlTag.HtmlSpan.class}, value={"todo-count"})})
            @Children.ChildrenMult(value={@Children(value={HtmlTag.HtmlDiv.class}), @Children(path={HtmlTag.HtmlDiv.class}, value={HtmlTag.HtmlSpan.class, Filters.class, ClearCompletedButton.class}), @Children(path={HtmlTag.HtmlDiv.class, HtmlTag.HtmlSpan.class}, value={ItemsLeft.class})})
            public static class TodosFooter
            extends HtmlTag.HtmlFooter {
                public void init() {
                    this.addContextAttribute("hasNoTodo", context -> new SimpleBooleanProperty());
                    this.addPrefixBinding(context -> context.getHtmlDomNode((Tag)this).getDisposables().add(TodoApp.getTodos(context).setOnChanged().map(set -> set.isEmpty()).subscribe(empty -> this.getContextProperty("hasNoTodo", (Context)context).setValue(empty))));
                    this.bindOptionalStyleClass("hidden", "hasNoTodo");
                }

                @StyleClass(value={"clear-completed"})
                public static class ClearCompletedButton
                extends HtmlTag.HtmlButton {
                    public void init() {
                        this.bindAction(model -> {
                            Property removing = this.getContextProperty("removing", (Context)model);
                            removing.setValue((Object)true);
                            TodoApp.getCompletedTodos(model).toList().forEach(DefaultWritable::remove);
                            removing.setValue((Object)false);
                        });
                        this.bindText(model -> TodoApp.getCompletedTodos(model).setOnChanged().map(list -> list.size()).map(size -> "Clear completed (" + size + ")"));
                        this.addContextAttribute("hasNoCompleted", context -> new SimpleBooleanProperty());
                        this.addPrefixBinding(context -> context.getHtmlDomNode((Tag)this).getDisposables().add(TodoApp.getCompletedTodos(context).setOnChanged().map(set -> set.isEmpty()).subscribe(empty -> this.getContextProperty("hasNoCompleted", (Context)context).setValue(empty))));
                        this.bindOptionalStyleClass("hidden", "hasNoCompleted");
                    }
                }

                @StyleClass(value={"filters"})
                @Children.ChildrenMult(value={@Children(value={HtmlTag.HtmlLi.class, HtmlTag.HtmlLi.class, HtmlTag.HtmlLi.class}), @Children(path={HtmlTag.HtmlLi.class}, pos={0}, value={ModeAllLink.class}), @Children(path={HtmlTag.HtmlLi.class}, pos={1}, value={ModeActiveLink.class}), @Children(path={HtmlTag.HtmlLi.class}, pos={2}, value={ModeCompleteLink.class})})
                public static class Filters
                extends HtmlTag.HtmlUl {

                    @SetText(value={"Completes"})
                    public static class ModeCompleteLink
                    extends HtmlTag.HtmlHyperLink {
                        public void init() {
                            this.bindAction(model -> TodoApp.getModeProperty((Tag)this, model).setValue(COMPLETE));
                            this.bindOptionalStyleClass("selected", "completeMode", model -> Bindings.equal((ObservableObjectValue)((ObservableObjectValue)TodoApp.getModeProperty((Tag)this, model)), COMPLETE));
                        }
                    }

                    @SetText(value={"Actives"})
                    public static class ModeActiveLink
                    extends HtmlTag.HtmlHyperLink {
                        public void init() {
                            this.bindAction(model -> TodoApp.getModeProperty((Tag)this, model).setValue(ACTIVE));
                            this.bindOptionalStyleClass("selected", "activeMode", model -> Bindings.equal((ObservableObjectValue)((ObservableObjectValue)TodoApp.getModeProperty((Tag)this, model)), ACTIVE));
                        }
                    }

                    @SetText(value={"All"})
                    public static class ModeAllLink
                    extends HtmlTag.HtmlHyperLink {
                        public void init() {
                            this.bindAction(model -> TodoApp.getModeProperty((Tag)this, model).setValue(ALL));
                            this.bindOptionalStyleClass("selected", "allMode", model -> Bindings.equal((ObservableObjectValue)((ObservableObjectValue)TodoApp.getModeProperty((Tag)this, model)), ALL));
                        }
                    }
                }

                public static class ItemsLeft
                extends HtmlTag.HtmlStrong {
                    public void init() {
                        this.bindText(context -> Observable.combineLatest((ObservableSource)TodoApp.getTodos(context).setOnChanged(), (ObservableSource)TodoApp.getCompletedTodos(context).setOnChanged(), (todos, completed) -> todos.size() - completed.size()).map(size -> size + " item" + (size > 1 ? "s" : "") + " left"));
                    }
                }
            }

            @StyleClass.StyleClasses(value={@StyleClass(value={"main"}), @StyleClass(path={HtmlTag.HtmlUl.class}, value={"todo-list"})})
            @Children.ChildrenMult(value={@Children(value={HtmlTag.HtmlUl.class}), @Children(path={HtmlTag.HtmlUl.class}, value={TodoItem.class})})
            @DirectSelect(path={HtmlTag.HtmlUl.class}, value={Todos.class})
            public static class TodosContent
            extends FlexDiv {

                @Children(value={ItemContent.class})
                @ForEach(value=ForEachExtractor.SUBINSTANCES.class)
                @Switch(value={StateFilter.class})
                public static class TodoItem
                extends HtmlTag.HtmlLi {
                    public void init() {
                        this.addContextAttribute(TodoApp.COMPLETED, context -> new SimpleBooleanProperty(completed.test(context.getGeneric())));
                        this.bindOptionalStyleClass(TodoApp.COMPLETED, TodoApp.COMPLETED);
                    }

                    @StyleClass.StyleClasses(value={@StyleClass(value={"view"}), @StyleClass(path={HtmlTag.HtmlButton.class}, value={"destroy"})})
                    @Children(value={TodoCheckBox.class, HtmlTag.HtmlLabel.GSLabelDisplayer.class, RemoveButton.class})
                    public static class ItemContent
                    extends HtmlTag.HtmlDiv {

                        public static class RemoveButton
                        extends HtmlTag.HtmlButton {
                            public void init() {
                                this.bindAction(context -> {
                                    this.getContextProperty("removing", (Context)context).setValue((Object)true);
                                    context.remove();
                                    this.getContextProperty("removing", (Context)context).setValue((Object)false);
                                });
                            }
                        }

                        @StyleClass(value={"toggle"})
                        @TagName(value="input", type="checkbox")
                        public static class TodoCheckBox
                        extends TagImpl {
                            public void init() {
                                this.addPrefixBinding(todo -> {
                                    Property completedProperty = this.getContextProperty(TodoApp.COMPLETED, (Context)todo);
                                    Property removing = this.getContextProperty("removing", (Context)todo);
                                    Observable completed = todo.getGeneric().getObservableHolder((DefaultGeneric)todo.getGeneric().getRoot().find(Todos.Completed.class), (DefaultGeneric[])new Generic[0]).map(opt -> opt.isPresent() && (Boolean)((Generic)opt.get()).getValue() != false).distinctUntilChanged();
                                    todo.getHtmlDomNode((Tag)this).getDisposables().add(completed.subscribe(bool -> completedProperty.setValue(bool)));
                                    completedProperty.addListener((o, v, nv) -> {
                                        if (todo.getGeneric().isAlive() && !((Boolean)removing.getValue()).booleanValue()) {
                                            todo.getGeneric().setHolder((DefaultGeneric)todo.find(Todos.Completed.class), (Serializable)nv, (DefaultGeneric[])new Generic[0]);
                                        }
                                    });
                                });
                                this.bindOptionalBiDirectionalAttribute(TodoApp.COMPLETED, "checked", "checked");
                            }
                        }
                    }
                }
            }

            @StyleClass(value={"new-todo"})
            @Attribute(name="placeholder", value="What needs to be done?")
            public static class TodoInput
            extends HtmlTag.HtmlInputText {
                public void init() {
                    this.bindAction(model -> {
                        String value = (String)this.getDomNodeAttributes((Context)model).get((Object)"value");
                        if (value != null && !value.isEmpty()) {
                            model.find(Todos.class).addInstance((Serializable)((Object)value), (DefaultGeneric[])new Generic[0]);
                        }
                        this.getDomNodeAttributes((Context)model).put((Object)"value", null);
                    });
                }
            }
        }
    }

    public static class StateFilter
    implements TagSwitcher {
        public Observable<Boolean> apply(Context context, Tag tag) {
            Generic todo = context.getGeneric();
            Observable completed = todo.getObservableHolder((DefaultGeneric)todo.getRoot().find(Todos.Completed.class), (DefaultGeneric[])new Generic[0]);
            Property<Predicate<Generic>> modeProp = TodoApp.getModeProperty(tag, context);
            return Observable.combineLatest((ObservableSource)completed, (ObservableSource)RxJavaHelpers.valuesOf(modeProp), (optCompleted, mode) -> mode.test(optCompleted.isPresent() ? (Generic)optCompleted.get() : null));
        }
    }
}

