/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.spring;

import java.util.Arrays;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.genericsystem.spring.CacheRequestProvider;
import org.genericsystem.spring.Engine;
import org.genericsystem.spring.PersistentDirectoryProvider;
import org.genericsystem.spring.UserClassesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Scope(value="singleton")
@Configuration
@Component
@Lazy
public class EngineProvider {
    protected static Logger log = LoggerFactory.getLogger(EngineProvider.class);
    private transient Engine engine;
    @Lazy
    @Autowired
    private UserClassesProvider userClassesProvider;
    @Lazy
    @Autowired
    private PersistentDirectoryProvider persistentDirectoryProvider;
    @Lazy
    @Autowired
    private CacheRequestProvider cacheRequestProvider;

    @PostConstruct
    public void init() {
        String logo = "\n";
        logo = logo + "____________________________________________________________________________________________________________\n";
        logo = logo + "|___________________________________________________________________________________________________________|\n";
        logo = logo + "|___________________________________________________________________________________________________________|\n";
        logo = logo + "|____________|         ____                      _      ____             __                  /______________|\n";
        logo = logo + "|____________|        / ___)___  _  _____  ___  /_)__  / ___)_  __ ___  / /  ___  ____      /_______________|\n";
        logo = logo + "|____________|       / /___/ __)/ \\/ / __)/ _ )/ |/ _)/___ \\/ \\/  ) __)/___)/ __)/    )    /________________|\n";
        logo = logo + "|____________|      / /_  / __)/    / __)/   \\/  / /_ ___/ /\\    (__  / /_ / __)/ / / /   /_________________|\n";
        logo = logo + "|____________|      \\____(____(_/\\_(____(_/\\_(__(____(____/  \\  (____(____(____(_/_/_/   /__________________|\n";
        logo = logo + "|____________|                                               /_/                        /___________________|\n";
        logo = logo + "|____________|_________________________________________________________________________/____________________|\n";
        logo = logo + "|___________________________________________________________________________________________________________|\n";
        logo = logo + "|___________________________________________________________________________________________________________|  \n";
        log.info(logo);
        log.info("-----------------------------------------------------------------------------------------------");
        log.info("-  directory path: {}", (Object)this.persistentDirectoryProvider.getDirectoryPath());
        log.info("-  userClasses: {}", (Object)Arrays.toString(this.userClassesProvider.getUserClassesArray()));
        log.info("-----------------------------------------------------------------------------------------------");
        this.engine = new Engine(() -> this.cacheRequestProvider.getCurrentCache(), this.persistentDirectoryProvider.getDirectoryPath(), this.userClassesProvider.getUserClassesArray());
    }

    @Bean
    @Lazy
    public Engine getEngine() {
        return this.engine;
    }

    @PreDestroy
    public void destroy() {
        log.info("Generic System is currently stopping...");
        this.engine.close();
        this.engine = null;
        log.info("Generic System is stopped");
    }
}

