/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.spring;

import java.io.IOException;
import java.util.ArrayList;
import org.genericsystem.api.core.annotations.SystemGeneric;
import org.genericsystem.spring.UserClassesProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.annotation.Scope;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import org.springframework.util.SystemPropertyUtils;

@Scope(value="singleton")
@Component
public class StartupBean {
    private final Logger log = LoggerFactory.getLogger(StartupBean.class);
    private final String basePackage = "org.genericsystem.models";

    private void findMyTypes(ApplicationContext applicationContext) throws IOException, ClassNotFoundException {
        UserClassesProvider userClasses = (UserClassesProvider)applicationContext.getBean(UserClassesProvider.class);
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        CachingMetadataReaderFactory metadataReaderFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
        String packageSearchPath = "classpath*:" + this.resolveBasePackage("org.genericsystem.models") + "/**/*.class";
        Resource[] resources = resourcePatternResolver.getResources(packageSearchPath);
        ArrayList resourcesClasses = new ArrayList();
        for (Resource resource : resources) {
            if (!resource.isReadable()) continue;
            MetadataReader metadataReader = metadataReaderFactory.getMetadataReader(resource);
            try {
                Class<?> c = Class.forName(metadataReader.getClassMetadata().getClassName());
                if (c.getAnnotation(SystemGeneric.class) == null) continue;
                this.log.info("Generic System: providing {}.", Class.forName(metadataReader.getClassMetadata().getClassName()));
                resourcesClasses.add(Class.forName(metadataReader.getClassMetadata().getClassName()));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        userClasses.setUserClasse(resourcesClasses);
    }

    private String resolveBasePackage(String basePackage) {
        return ClassUtils.convertClassNameToResourcePath((String)SystemPropertyUtils.resolvePlaceholders((String)basePackage));
    }

    @EventListener
    public void onApplicationEvent(ApplicationEvent event) throws ClassNotFoundException, IOException {
        if (event instanceof ContextRefreshedEvent) {
            ApplicationContext applicationContext = ((ContextRefreshedEvent)event).getApplicationContext();
            this.findMyTypes(applicationContext);
        }
    }
}

