/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.spring;

import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.genericsystem.kernel.Cache;
import org.genericsystem.spring.CacheSessionProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Component;

@Configuration
@Component
@Lazy
@Scope(value="request")
public class CacheRequestProvider {
    @Lazy
    @Autowired
    private transient CacheSessionProvider cacheSessionProvider;

    @PostConstruct
    public void init() {
        this.cacheSessionProvider.getCurrentCache().start();
    }

    @Bean
    @Lazy
    public Cache getCurrentCache() {
        return this.cacheSessionProvider.getCurrentCache();
    }

    @PreDestroy
    public void preDestroy() {
        this.cacheSessionProvider.getCurrentCache().stop();
    }
}

