/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.genericsystem.reinforcer.Label;
import org.genericsystem.reinforcer.Labels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TableExtractor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public static List<Table> extractTables(Labels labels) {
        List<List<Label>> lines = labels.groupByLine();
        ArrayList<Block> blocks = new ArrayList<Block>();
        Block currentBlock = null;
        logger.info("Lines found: {}", lines);
        for (List<Label> line : lines) {
            if (line.size() > 1) {
                if (currentBlock != null) {
                    currentBlock.addLine(line);
                    continue;
                }
                currentBlock = new Block();
                currentBlock.addLine(line);
                continue;
            }
            if (currentBlock != null) {
                blocks.add(currentBlock);
            }
            blocks.add(new Block().addLine(line));
            currentBlock = null;
        }
        if (currentBlock != null) {
            blocks.add(currentBlock);
        }
        logger.info("Blocks: {}", blocks);
        ArrayList<Table> tables = new ArrayList<Table>();
        for (Block block : blocks) {
            if (block.size() <= 1) continue;
            tables.add(new Table(block.createColumns()));
        }
        logger.info("Tables found: {}", tables);
        return tables;
    }

    public static class Cell {
        private int line;
        private List<Label> contents = new ArrayList<Label>();

        public Cell(int line) {
            this.line = line;
        }

        void addContent(Label label) {
            this.contents.add(label);
        }

        public String toString() {
            return "Cell, line " + this.line + ": " + this.contents.toString();
        }
    }

    public static class Column {
        private Map<Integer, Cell> cells = new HashMap<Integer, Cell>();
        private double minX = Double.MAX_VALUE;
        private double maxX = 0.0;

        void addContent(int lineNo, Label label) {
            if (this.cells.containsKey(lineNo)) {
                this.cells.get(lineNo).addContent(label);
            } else {
                Cell newCell = new Cell(lineNo);
                newCell.addContent(label);
                this.cells.put(lineNo, newCell);
            }
            double x = label.getRect().getX();
            double x2 = x + label.getRect().getWidth();
            if (x < this.minX) {
                this.minX = x;
            }
            if (x2 > this.maxX) {
                this.maxX = x2;
            }
        }

        public boolean overlaps(Label label) {
            return label.getRect().br().getX() > this.minX && label.getRect().getX() < this.maxX;
        }

        public String toString() {
            return "\nColumn: minX: " + this.minX + ", maxX: " + this.maxX + ", cells: " + this.cells.toString();
        }
    }

    public static class Table {
        private final List<Column> columns;

        public Table(List<Column> columns) {
            this.columns = columns;
        }

        public int nbColumns() {
            return this.columns.size();
        }

        public String toString() {
            return "Table " + this.columns;
        }
    }

    public static class Block {
        List<List<Label>> lines = new ArrayList<List<Label>>();

        public Block addLine(List<Label> line) {
            this.lines.add(line);
            return this;
        }

        public int size() {
            return this.lines.size();
        }

        List<Column> createColumns() {
            ArrayList<Column> columns = new ArrayList<Column>();
            int lineNo = 0;
            for (List<Label> line : this.lines) {
                for (Label label : line) {
                    Column column = this.findColumn(columns, label);
                    if (column != null) {
                        column.addContent(lineNo, label);
                        continue;
                    }
                    column = new Column();
                    column.addContent(lineNo, label);
                    columns.add(column);
                }
                ++lineNo;
            }
            return columns;
        }

        private Column findColumn(List<Column> columns, Label label) {
            for (Column column : columns) {
                if (!column.overlaps(label)) continue;
                return column;
            }
            return null;
        }

        public String toString() {
            return "\nBlock: " + this.lines;
        }
    }
}

