/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer.tools;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.function.BiConsumer;
import java.util.stream.Stream;
import org.genericsystem.reinforcer.Label;
import org.genericsystem.reinforcer.Labels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextExtractor {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String sourceDirPath = "pieces/json";
    private static final String targetDirPath = "pieces/text";
    private static final String textFilePath = "pieces/textData";

    public static void main(String[] args) {
        TextExtractor.extractText();
        TextExtractor.extractTextFiles();
    }

    public static void forEachSubFile(Path sourceDir, BiConsumer<Path, Path> fileAction) {
        try (Stream<Path> stream = Files.list(sourceDir);){
            stream.filter(path -> Files.isDirectory(path, new LinkOption[0])).forEach(dir -> {
                try (DirectoryStream<Path> files = Files.newDirectoryStream(dir, path -> Files.isRegularFile(path, new LinkOption[0]));){
                    files.forEach(file -> fileAction.accept((Path)dir, (Path)file));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void extractText() {
        Path sourceDir = Paths.get(sourceDirPath, new String[0]);
        StringBuilder data = new StringBuilder();
        TextExtractor.forEachSubFile(sourceDir, (dir, file) -> {
            Labels labels = Labels.from(file).sort();
            for (Label label : labels) {
                data.append(label.getText());
                data.append(" ");
            }
        });
        try (BufferedWriter bf = new BufferedWriter(new FileWriter(textFilePath));){
            bf.write(data.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void extractTextFiles() {
        Path sourceDir = Paths.get(sourceDirPath, new String[0]);
        Path targetDir = Paths.get(targetDirPath, new String[0]);
        TextExtractor.forEachSubFile(sourceDir, (dir, file) -> {
            StringBuilder data = new StringBuilder();
            Labels labels = Labels.from(file).sort();
            for (Label label : labels) {
                data.append(label.getText());
                data.append(" ");
            }
            Path saveFile = targetDir.resolve(sourceDir.relativize((Path)file)).resolveSibling(file.getFileName().toString() + ".txt");
            try {
                Files.createDirectories(saveFile.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try (BufferedWriter bf = new BufferedWriter(new FileWriter(saveFile.toFile()));){
                bf.write(data.toString());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }
}

