/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import io.reactivex.functions.Consumer;
import io.reactivex.subjects.PublishSubject;
import java.util.HashMap;
import java.util.Map;
import org.genericsystem.reinforcer.Labels;
import org.genericsystem.reinforcer.Template;
import org.genericsystem.reinforcer.Unclassifiable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reinforcer {
    private static final Logger logger = LoggerFactory.getLogger(Reinforcer.class);
    private static final double MATCHING_RATE = 0.8;
    private final Map<String, Template> templates = new HashMap<String, Template>();
    private final Unclassifiable unclassifiable = new Unclassifiable();

    public static void main(String[] args) {
        Reinforcer reinforcer = new Reinforcer();
        PublishSubject source = PublishSubject.create();
        source.subscribe(reinforcer.getObserver());
        Labels labels = new Labels();
        labels.addLabel(0.0, 0.0, 10.0, 10.0, "First Label");
        labels.addLabel(5.0, 5.0, 15.0, 15.0, "Second Label");
        source.onNext((Object)labels);
    }

    public Consumer<Labels> getObserver() {
        return labels -> this.reinforce((Labels)labels);
    }

    public void reinforce(Labels labels, String templateName) {
        Template template = this.templates.get(templateName);
        if (template != null) {
            template.reinforce(labels);
        } else {
            logger.warn("No template of name {} found.", (Object)templateName);
        }
    }

    public void createNewTemplate(Labels labels, String templateName) {
        if (this.templates.containsKey(templateName)) {
            throw new IllegalStateException("A template with name " + templateName + " already exists.");
        }
        Template template = new Template(labels);
        this.templates.put(templateName, template);
    }

    public String getBestTemplate(Labels labels) {
        double bestMatchRate = 0.0;
        String bestTemplate = null;
        for (Map.Entry<String, Template> entry : this.templates.entrySet()) {
            logger.info("Testing template " + entry.getKey());
            double matchRate = entry.getValue().getMatchRate(labels);
            if (!(matchRate > bestMatchRate)) continue;
            bestMatchRate = matchRate;
            bestTemplate = entry.getKey();
        }
        if (bestMatchRate > 0.8) {
            logger.info("Best template found: {}, labels: {}", bestTemplate, (Object)labels);
            return bestTemplate;
        }
        logger.info("No template found, labels: {}", (Object)labels);
        return null;
    }

    public void reinforce(Labels absoluteLabels) {
        double bestMatchRate = 0.0;
        Template bestTemplate = null;
        for (Template template : this.templates.values()) {
            double matchRate = template.getMatchRate(absoluteLabels);
            if (!(matchRate > bestMatchRate)) continue;
            bestMatchRate = matchRate;
            bestTemplate = template;
        }
        if (bestMatchRate > 0.8) {
            bestTemplate.reinforce(absoluteLabels);
        }
        this.unclassifiable.reinforce(absoluteLabels);
    }

    public Unclassifiable getUnclassifiable() {
        return this.unclassifiable;
    }
}

