/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import java.text.Collator;
import org.genericsystem.reinforcer.Alignment;
import org.genericsystem.reinforcer.Direction;
import org.genericsystem.reinforcer.tools.GSPoint;
import org.genericsystem.reinforcer.tools.GSRect;
import org.genericsystem.reinforcer.tools.RectangleTools;
import org.genericsystem.reinforcer.tools.StringCompare;

public class Label
implements Comparable<Label> {
    private final GSRect rect;
    private final String label;

    public Label(double tlx, double tly, double brx, double bry, String label) {
        assert (tlx < brx && tly < bry) : "tlx: " + tlx + ", brx: " + brx + ", tly: " + tly + ", bry: " + bry;
        this.rect = new GSRect(tlx, tly, brx - tlx, bry - tly);
        this.label = label;
    }

    public Label(GSRect rect, String label) {
        this.rect = rect;
        this.label = label;
    }

    public String toString() {
        return "{Label " + this.rect.toString() + ", content: " + this.label + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Label)) {
            return false;
        }
        Label al = (Label)obj;
        return al.rect.equals(this.rect) && this.label.equals(al.label);
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public GSRect getRect() {
        return this.rect;
    }

    public String getText() {
        return this.label;
    }

    public Label normalize(double mintlx, double mintly, double width, double height) {
        return new Label(this.rect.normalize(mintlx, mintly, width, height), this.label);
    }

    public Label affineTransform(double xScale, double xShift, double yScale, double yShift) {
        double newX = xScale * this.rect.getX() + xShift;
        double newBrX = xScale * this.rect.br().getX() + xShift;
        double newY = yScale * this.rect.getY() + yShift;
        double newBrY = yScale * this.rect.br().getY() + yShift;
        return new Label(newX, newY, newBrX, newBrY, this.label);
    }

    public boolean matchesText(String text) {
        return StringCompare.similar(text, this.label, StringCompare.SIMILARITY.LEVENSHTEIN);
    }

    public boolean isInDirection(Label other, Direction direction) {
        GSPoint center = this.getRect().getCenter();
        GSRect otherRect = other.getRect();
        boolean north = center.getY() < otherRect.getY();
        boolean east = center.getX() > otherRect.getX() + otherRect.getWidth();
        boolean south = center.getY() > otherRect.getY() + otherRect.getHeight();
        boolean west = center.getX() < otherRect.getX();
        switch (direction) {
            case NORTH_EAST: {
                return east && north;
            }
            case NORTH: {
                return north && !east && !west;
            }
            case NORTH_WEST: {
                return north && west;
            }
            case WEST: {
                return west && !south && !north;
            }
            case SOUTH_WEST: {
                return south && west;
            }
            case SOUTH: {
                return south && !west && !east;
            }
            case SOUTH_EAST: {
                return south && east;
            }
        }
        return east && !south && !north;
    }

    public double alignmentCost(Label other) {
        double result = RectangleTools.isInCluster(this.rect, other.rect, 0.2) ? 0.0 : (this.alignedWith(other, Alignment.LEFT) || this.alignedWith(other, Alignment.RIGHT) ? 0.4 : 0.8);
        return result;
    }

    public boolean alignedWith(Label other, Alignment alignment) {
        double xOther;
        double xThis;
        double tolerance = 0.05;
        if (alignment == Alignment.LEFT) {
            xThis = this.rect.getX();
            xOther = other.rect.getX();
        } else {
            xThis = this.rect.getX() + this.rect.getWidth();
            xOther = other.rect.getX() + other.getRect().getWidth();
        }
        return Math.abs(xThis - xOther) < tolerance * Math.max(xThis, xOther);
    }

    @Override
    public int compareTo(Label o) {
        if (this == o) {
            return 0;
        }
        int rectDiff = this.rect.compareTo(o.rect);
        if (rectDiff != 0) {
            return rectDiff;
        }
        return Collator.getInstance().compare(this.label, o.label);
    }
}

