/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer.tools;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CosineSimilarity {
    public static void main(String[] args) {
        System.out.println(CosineSimilarity.cosineSimilarity("bob", "rob", PATTERN.SINGLE_CHAR));
        System.out.println(CosineSimilarity.cosineSimilarity("hello", "molehill", PATTERN.SINGLE_CHAR));
    }

    public static double cosineSimilarity(String string1, String string2, PATTERN splitPattern) {
        if (null == string1 || null == string2) {
            throw new IllegalArgumentException("Cosine similarity requires two not null strings");
        }
        if (string1.equals(string2)) {
            return 1.0;
        }
        if (string1.isEmpty() || string2.isEmpty()) {
            return 0.0;
        }
        Map<String, Long> a = CosineSimilarity.getFrequencyMap(string1, splitPattern);
        Map<String, Long> b = CosineSimilarity.getFrequencyMap(string2, splitPattern);
        HashSet<String> intersection = new HashSet<String>(a.keySet());
        intersection.retainAll(b.keySet());
        if (intersection.isEmpty()) {
            return 0.0;
        }
        double dotProduct = intersection.stream().mapToDouble(s -> (Long)a.get(s) * (Long)b.get(s)).sum();
        double magnitudeA = a.values().stream().mapToDouble(i -> Math.pow(i.longValue(), 2.0)).sum();
        double magnitudeB = b.values().stream().mapToDouble(i -> Math.pow(i.longValue(), 2.0)).sum();
        return dotProduct / Math.sqrt(magnitudeA * magnitudeB);
    }

    public static Map<String, Long> getFrequencyMap(String string, PATTERN splitPattern) {
        List<String> chars = Arrays.asList(splitPattern.getPattern().split(string.trim()));
        return chars.stream().collect(Collectors.groupingBy(s -> s, Collectors.counting()));
    }

    public static enum PATTERN {
        SINGLE_CHAR(Pattern.compile("(?!^)")),
        WORDS(Pattern.compile("\\W+")),
        SPACE(Pattern.compile("\\S+"));

        private Pattern pattern;

        private PATTERN(Pattern splitPattern) {
            this.pattern = splitPattern;
        }

        public Pattern getPattern() {
            return this.pattern;
        }
    }
}

