/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.reinforcer.AffineTransformation;
import org.genericsystem.reinforcer.Alignment;
import org.genericsystem.reinforcer.Constraint;
import org.genericsystem.reinforcer.Direction;
import org.genericsystem.reinforcer.Label;
import org.genericsystem.reinforcer.PagePart;
import org.genericsystem.reinforcer.Template3;
import org.genericsystem.reinforcer.tools.GSPoint;
import org.genericsystem.reinforcer.tools.GSRect;
import org.genericsystem.reinforcer.tools.JsonLabel;
import org.genericsystem.reinforcer.tools.StringCompare;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Labels
implements Iterable<Label> {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final List<Label> labels;
    private static final double THRESHOLD = 0.1;
    private static final ObjectMapper mapper = new ObjectMapper();
    private Comparator<Label> labelComparator = (l1, l2) -> {
        GSRect r1 = l1.getRect();
        GSRect r2 = l2.getRect();
        if (r1.getY() != r2.getY()) {
            return Double.compare(r1.getY(), r2.getY());
        }
        return Double.compare(r1.getX(), r2.getX());
    };
    Function<Label, Predicate<Template3.LabelDesc>> getTest = label -> ld -> ld.getLabel() == label;

    public Labels() {
        this.labels = new ArrayList<Label>();
    }

    public Labels(List<Label> labels) {
        this.labels = labels;
    }

    public static Labels from(Path file) {
        try {
            JsonLabel.JsonLabels jsonLabels = (JsonLabel.JsonLabels)mapper.readValue(file.toFile(), JsonLabel.JsonLabels.class);
            Labels result = new Labels();
            for (JsonLabel label : jsonLabels.getFields()) {
                if (!label.getChildren().isEmpty() || label.getLabels().isEmpty()) continue;
                String text = Labels.bestOcr(label.getLabels());
                result.addLabel(new Label(label.getOcrRect(), text));
            }
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static String bestOcr(Map<String, Integer> labels) {
        String best = null;
        int bestScore = 0;
        for (Map.Entry<String, Integer> entry : labels.entrySet()) {
            if (entry.getValue() <= bestScore) continue;
            bestScore = entry.getValue();
            best = entry.getKey();
        }
        return best;
    }

    public boolean addLabel(double tlx, double tly, double brx, double bry, String candidateLabel) {
        Label candidate = new Label(tlx, tly, brx, bry, candidateLabel);
        return this.addLabel(candidate);
    }

    public boolean addLabel(Label candidate) {
        for (Label label : this.labels) {
            if (!label.getRect().isOverlappingStrict(candidate.getRect())) continue;
            throw new IllegalStateException(label + " intersect with : " + candidate);
        }
        return this.labels.add(candidate);
    }

    public String toString() {
        return this.labels.toString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Labels)) {
            return false;
        }
        return this.labels.equals(((Labels)obj).labels);
    }

    public int hashCode() {
        return this.labels.hashCode();
    }

    public List<Template3.Match> alignWith(Labels item) {
        ArrayList<Template3.Match> matches = new ArrayList<Template3.Match>();
        for (Label label : this) {
            for (Label other : item) {
                if (!StringCompare.similar(label.getText(), other.getText(), StringCompare.SIMILARITY.LEVENSHTEIN)) continue;
                matches.add(new Template3.Match(label, other));
            }
        }
        if (matches.isEmpty()) {
            return new ArrayList<Template3.Match>();
        }
        MatchListWithRate bestMatches = null;
        HashSet<Integer> tested = new HashSet<Integer>();
        for (int i = 0; i < matches.size(); ++i) {
            if (!tested.add(i)) continue;
            HashSet<Template3.Match> selectedMatches = new HashSet<Template3.Match>();
            selectedMatches.add((Template3.Match)matches.get(i));
            AffineTransformation possibleTransformation = new AffineTransformation(selectedMatches);
            for (int j = 0; j < matches.size(); ++j) {
                if (j == i || tested.contains(j) || !(possibleTransformation.computeError((Template3.Match)matches.get(j)) < 0.1)) continue;
                selectedMatches.add((Template3.Match)matches.get(j));
                tested.add(j);
            }
            possibleTransformation = new AffineTransformation(selectedMatches);
            Labels aligned = possibleTransformation.transform(this);
            MatchListWithRate result = aligned.matchRate(item);
            if (bestMatches != null && !(result.matchRate > bestMatches.matchRate)) continue;
            bestMatches = result;
            if (bestMatches.matchRate == 1.0) break;
        }
        return bestMatches.matchList;
    }

    public Labels sort() {
        Collections.sort(this.labels, this.labelComparator);
        return this;
    }

    public Direction contentDirection(Label label, List<Template3.LabelDesc> description) {
        Label neighbor = this.getDirectNeighbor(label, Direction.EAST);
        if (neighbor != null && !description.stream().anyMatch(this.getTest.apply(neighbor))) {
            return Direction.EAST;
        }
        neighbor = this.getDirectNeighbor(label, Direction.SOUTH);
        if (neighbor != null && !description.stream().anyMatch(this.getTest.apply(neighbor))) {
            return Direction.SOUTH;
        }
        throw new IllegalStateException("Impossible to detect content direction for " + label + " among " + this);
    }

    private MatchListWithRate matchRate(Labels others) {
        int m = this.size();
        int n = others.size();
        List<Label> l1 = this.toList();
        Collections.sort(l1, this.labelComparator);
        List<Label> l2 = others.toList();
        Collections.sort(l2, this.labelComparator);
        Object[] costsAndSteps = this.computeCostsAndSteps(l1, l2, m, n);
        Step[][] steps = (Step[][])costsAndSteps[1];
        List<Template3.Match> bestMatch = this.computeBestMatch(l1, l2, steps, m, n);
        double[][] costs = (double[][])costsAndSteps[0];
        double total = costs[m][n];
        total /= (double)others.size();
        total = 1.0 - total;
        return new MatchListWithRate(bestMatch, total);
    }

    private Object[] computeCostsAndSteps(List<Label> source, List<Label> target, int m, int n) {
        int i;
        double[][] costs = new double[m + 1][n + 1];
        costs[0][0] = 0.0;
        for (int i2 = 1; i2 <= m; ++i2) {
            costs[i2][0] = costs[i2 - 1][0] + this.insertionCost(source.get(i2 - 1));
        }
        for (int j = 1; j <= n; ++j) {
            costs[0][j] = costs[0][j - 1] + this.insertionCost(target.get(j - 1));
        }
        Step[][] steps = new Step[m + 1][n + 1];
        steps[0][0] = Step.NONE;
        for (i = 1; i <= m; ++i) {
            steps[i][0] = Step.INSERTION;
        }
        for (int j = 1; j <= n; ++j) {
            steps[0][j] = Step.DELETION;
        }
        for (i = 1; i <= m; ++i) {
            for (int j = 1; j <= n; ++j) {
                double costInsertion = costs[i - 1][j] + this.insertionCost(source.get(i - 1));
                double costNoChange = costs[i - 1][j - 1] + source.get(i - 1).alignmentCost(target.get(j - 1));
                double costDeletion = costs[i][j - 1] + this.insertionCost(target.get(j - 1));
                costs[i][j] = Math.min(costNoChange, Math.min(costInsertion, costDeletion));
                steps[i][j] = costs[i][j] == costNoChange ? Step.NONE : (costs[i][j] == costInsertion ? Step.INSERTION : Step.DELETION);
            }
        }
        Object[] result = new Object[]{costs, steps};
        return result;
    }

    private List<Template3.Match> computeBestMatch(List<Label> source, List<Label> target, Step[][] steps, int i, int j) {
        List<Template3.Match> bestMatch;
        if (i == 0 && j == 0) {
            return new ArrayList<Template3.Match>();
        }
        switch (steps[i][j]) {
            case NONE: {
                bestMatch = this.computeBestMatch(source, target, steps, i - 1, j - 1);
                bestMatch.add(new Template3.Match(source.get(i - 1), target.get(j - 1)));
                break;
            }
            case INSERTION: {
                bestMatch = this.computeBestMatch(source, target, steps, i - 1, j);
                bestMatch.add(new Template3.Match(source.get(i - 1), null));
                break;
            }
            default: {
                bestMatch = this.computeBestMatch(source, target, steps, i, j - 1);
                bestMatch.add(new Template3.Match(null, target.get(j - 1)));
            }
        }
        return bestMatch;
    }

    private double insertionCost(Label label) {
        return 1.0;
    }

    public Labels normalizeLabels() {
        double mintlx = Double.MAX_VALUE;
        double mintly = Double.MAX_VALUE;
        double maxbrx = 0.0;
        double maxbry = 0.0;
        for (GSRect rect : this.labels.stream().map(l -> l.getRect()).collect(Collectors.toList())) {
            if (rect.getX() < mintlx) {
                mintlx = rect.getX();
            }
            if (rect.getY() < mintly) {
                mintly = rect.getY();
            }
            if (rect.br().getX() > maxbrx) {
                maxbrx = rect.br().getX();
            }
            if (!(rect.br().getY() > maxbry)) continue;
            maxbry = rect.br().getY();
        }
        double width = maxbrx - mintlx;
        double height = maxbry - mintly;
        Labels normalized = new Labels();
        for (Label label : this.labels) {
            normalized.addLabel(label.normalize(mintlx, mintly, width, height));
        }
        return normalized;
    }

    @Override
    public Iterator<Label> iterator() {
        return this.labels.iterator();
    }

    public List<Label> toList() {
        return this.stream().collect(Collectors.toList());
    }

    public Stream<Label> stream() {
        return this.labels.stream();
    }

    public int size() {
        return this.labels.size();
    }

    public List<Label> getNeighbors(Label label, Direction direction) {
        return this.labels.stream().filter(l -> l != label && l.isInDirection(label, direction)).collect(Collectors.toList());
    }

    public Label getDirectNeighbor(Label label, Direction direction) {
        List<Label> neighbors = this.getNeighbors(label, direction);
        if (neighbors.isEmpty()) {
            return null;
        }
        if (neighbors.size() == 1) {
            return neighbors.get(0);
        }
        Collections.sort(neighbors);
        switch (direction) {
            case NORTH: 
            case NORTH_EAST: 
            case NORTH_WEST: 
            case WEST: {
                return neighbors.get(neighbors.size() - 1);
            }
        }
        return neighbors.get(0);
    }

    public PagePart getPosition(Label label) {
        double xMin = Double.MAX_VALUE;
        double yMin = Double.MAX_VALUE;
        double xMax = 0.0;
        double yMax = 0.0;
        for (Label l : this.labels) {
            GSRect rect = l.getRect();
            if (rect.getX() < xMin) {
                xMin = rect.getX();
            }
            if (rect.getY() < yMin) {
                yMin = rect.getY();
            }
            if (rect.getX() + rect.getWidth() > xMax) {
                xMax = rect.getX() + rect.getWidth();
            }
            if (!(rect.getY() + rect.getHeight() > yMax)) continue;
            yMax = rect.getY() + rect.getHeight();
        }
        double width = xMax - xMin;
        double height = yMax - yMin;
        GSPoint center = label.getRect().getCenter();
        int xPos = center.getX() < xMin + width / 3.0 ? 0 : (center.getX() > xMax - width / 3.0 ? 2 : 1);
        int yPos = center.getY() < yMin + height / 3.0 ? 0 : (center.getY() > yMax - height / 3.0 ? 2 : 1);
        if (xPos == 0 && yPos == 0) {
            return PagePart.NORTH_WEST;
        }
        if (xPos == 0 && yPos == 1) {
            return PagePart.WEST;
        }
        if (xPos == 0 && yPos == 2) {
            return PagePart.SOUTH_WEST;
        }
        if (xPos == 1 && yPos == 0) {
            return PagePart.NORTH;
        }
        if (xPos == 1 && yPos == 1) {
            return PagePart.CENTER;
        }
        if (xPos == 1 && yPos == 2) {
            return PagePart.SOUTH;
        }
        if (xPos == 2 && yPos == 0) {
            return PagePart.NORTH_EAST;
        }
        if (xPos == 2 && yPos == 1) {
            return PagePart.EAST;
        }
        return PagePart.SOUTH_EAST;
    }

    public List<Constraint> getConstraints() {
        ArrayList<Constraint> result = new ArrayList<Constraint>();
        for (Label label : this) {
            PagePart pos = this.getPosition(label);
            result.add(new Constraint.PositionConstraint(this.getPosition(label), label.getText()));
            for (Direction direction : Direction.values()) {
                Label neighbour = this.getDirectNeighbor(label, direction);
                if (neighbour == null) continue;
                result.add(new Constraint.RelationConstraint(pos, label.getText(), direction, neighbour.getText()));
            }
        }
        result.add(new Constraint.ColsConstraint(this));
        return result;
    }

    private List<List<Label>> groupBy(List<Label> labels, BiFunction<Label, Label, Boolean> equals) {
        if (labels.isEmpty()) {
            return new ArrayList<List<Label>>();
        }
        ArrayList<List<Label>> result = new ArrayList<List<Label>>();
        ArrayList<Label> currentGroup = new ArrayList<Label>(Arrays.asList(labels.get(0)));
        for (int i = 1; i < labels.size(); ++i) {
            if (equals.apply((Label)currentGroup.get(0), labels.get(i)).booleanValue()) {
                currentGroup.add(labels.get(i));
                continue;
            }
            result.add(currentGroup);
            currentGroup = new ArrayList<Label>(Arrays.asList(labels.get(i)));
        }
        result.add(currentGroup);
        return result;
    }

    public List<List<Label>> groupAlignedLabels(Alignment alignment) {
        List<Label> ll = this.toList();
        Collections.sort(ll, (l1, l2) -> {
            if (alignment == Alignment.LEFT) {
                return Double.compare(l1.getRect().getX(), l2.getRect().getX());
            }
            return Double.compare(l1.getRect().br().getX(), l2.getRect().br().getX());
        });
        return this.groupBy(ll, (l1, l2) -> l1.alignedWith((Label)l2, alignment));
    }

    private List<List<Label>> byLine(List<Label> labels) {
        Collections.sort(labels);
        return this.groupBy(labels, (l1, l2) -> {
            GSRect r1 = l1.getRect();
            GSRect r2 = l2.getRect();
            return r1.vOverlaps(r2);
        });
    }

    public List<List<Label>> groupByLine() {
        return this.byLine(this.toList());
    }

    private List<Label> computeOverlapping(Label label, List<List<Label>> lines) {
        int lineNo = 0;
        for (int i = 0; i <= lines.size(); ++i) {
            if (!lines.get(i).contains(label)) continue;
            lineNo = i;
            break;
        }
        ArrayList<Label> overlaps = new ArrayList<Label>();
        if (lineNo > 0) {
            for (Label other : lines.get(lineNo - 1)) {
                if (!label.getRect().hOverlaps(other.getRect())) continue;
                overlaps.add(other);
            }
        }
        if (lineNo < lines.size() - 1) {
            for (Label other : lines.get(lineNo + 1)) {
                if (!label.getRect().hOverlaps(other.getRect())) continue;
                overlaps.add(other);
            }
        }
        return overlaps;
    }

    private List<Label> expandBlock(Label label, List<Label> block, List<List<Label>> lines, Set<Label> expanded) {
        expanded.add(label);
        block.add(label);
        for (Label other : this.computeOverlapping(label, lines)) {
            if (!expanded.add(other)) continue;
            this.expandBlock(other, block, lines, expanded);
        }
        return block;
    }

    private List<List<Label>> findBlocks() {
        HashSet<Label> expanded = new HashSet<Label>();
        List<List<Label>> lines = this.groupByLine();
        ArrayList<List<Label>> blocks = new ArrayList<List<Label>>();
        for (Label label : this) {
            if (expanded.contains(label)) continue;
            blocks.add(this.expandBlock(label, new ArrayList<Label>(), lines, expanded));
        }
        return blocks;
    }

    public List<List<Label>> findCols() {
        List<List<Label>> blocks = this.findBlocks();
        return blocks.stream().filter(block -> {
            List<List<Label>> lines = this.byLine((List<Label>)block);
            return lines.size() > 1 && lines.stream().allMatch(line -> line.size() == 1);
        }).collect(Collectors.toList());
    }

    public static class MatchListWithRate {
        protected final List<Template3.Match> matchList;
        protected final double matchRate;

        MatchListWithRate(List<Template3.Match> matchList, double matchRate) {
            this.matchList = matchList;
            this.matchRate = matchRate;
        }

        public String toString() {
            return this.matchList + ", matchRate: " + this.matchRate;
        }
    }

    private static enum Step {
        INSERTION,
        DELETION,
        NONE;

    }
}

