/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.genericsystem.reinforcer.tools.CosineSimilarity;
import org.genericsystem.reinforcer.tools.LetterPairSimilarity;
import org.genericsystem.reinforcer.tools.Levenshtein;

public class StringCompare {
    private static final int DEFAULT_K = 3;
    private static final Pattern SPACE_PATTERN = Pattern.compile("\\s+");

    public static void main(String[] args) {
        System.out.println(StringCompare.containsSubstring("Bonjour mon ami, avez-vous vu le soleil ?", "solell", 0.7, SIMILARITY.LEVENSHTEIN));
    }

    public static boolean containsSubstring(String original, String candidate) {
        if (original == null || candidate == null) {
            throw new IllegalArgumentException("Attempt to compare one (or more) null strings");
        }
        if (original.trim().isEmpty() || candidate.trim().isEmpty()) {
            return false;
        }
        String candidateNoSpaces = SPACE_PATTERN.matcher(candidate.toLowerCase()).replaceAll("");
        int k = candidateNoSpaces.length();
        Set<String> shingles = StringCompare.getShinglesSpacesRemoved(original.toLowerCase(), k);
        return shingles.stream().anyMatch(s -> s.equals(candidateNoSpaces));
    }

    public static boolean containsSubstring(String original, String candidate, double similarityThreshold, SIMILARITY option) {
        if (original == null || candidate == null) {
            throw new IllegalArgumentException("Attempt to compare one (or more) null strings");
        }
        if (original.trim().isEmpty() || candidate.trim().isEmpty()) {
            return false;
        }
        String candidateNoSpaces = SPACE_PATTERN.matcher(candidate.toLowerCase()).replaceAll("");
        int k = candidateNoSpaces.length();
        Set<String> shingles = StringCompare.getShinglesSpacesRemoved(original.toLowerCase(), k);
        return shingles.stream().anyMatch(s -> {
            double sim = StringCompare.compare(s, candidateNoSpaces, option);
            return sim > similarityThreshold;
        });
    }

    public static double compare(String string1, String string2, SIMILARITY option) {
        double sim = 0.0;
        switch (option) {
            default: {
                sim = Levenshtein.similarity(string1.trim(), string2.trim());
                break;
            }
            case LETTER_PAIRS: {
                sim = LetterPairSimilarity.compareStrings(string1.trim(), string2.trim());
                break;
            }
            case COSINE_CHAR: {
                sim = CosineSimilarity.cosineSimilarity(string1.trim(), string2.trim(), CosineSimilarity.PATTERN.SINGLE_CHAR);
                break;
            }
            case COSINE_WORD: {
                sim = CosineSimilarity.cosineSimilarity(string1.trim(), string2.trim(), CosineSimilarity.PATTERN.WORDS);
            }
        }
        return sim;
    }

    public static boolean similar(String string1, String string2, SIMILARITY option) {
        return StringCompare.compare(string1, string2, option) >= 0.7;
    }

    public static double similarity(List<String> strings, SIMILARITY option) {
        double sim = 0.0;
        int n = strings.size();
        if (n == 1) {
            return 1.0;
        }
        for (int i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                sim += StringCompare.compare(strings.get(i), strings.get(j), option);
            }
        }
        return 2.0 * sim / (double)(n * (n - 1));
    }

    public static Set<String> getShinglesSpacesRemoved(String string) {
        return StringCompare.getShinglesSpacesRemoved(string, 3);
    }

    public static Set<String> getShinglesSpacesRemoved(String string, int k) {
        String stringNoSpaces = SPACE_PATTERN.matcher(string).replaceAll("");
        return StringCompare.getShingles(stringNoSpaces, k);
    }

    public static Set<String> getShingles(String string) {
        return StringCompare.getShingles(string, 3);
    }

    public static Set<String> getShingles(String string, int k) {
        if (k <= 0) {
            throw new IllegalArgumentException(String.format("k should be positive (provided value: %d)", k));
        }
        if (string == null || string.isEmpty()) {
            return Collections.emptySet();
        }
        Set<String> shingles = SPACE_PATTERN.splitAsStream(string.toLowerCase()).flatMap(word -> {
            if (word.length() < k) {
                return Stream.empty();
            }
            int size = word.length() - k + 1;
            ArrayList<String> tmp = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                tmp.add(word.substring(i, i + k));
            }
            return tmp.stream();
        }).collect(Collectors.toSet());
        return shingles;
    }

    public static enum SIMILARITY {
        LEVENSHTEIN,
        LETTER_PAIRS,
        COSINE_CHAR,
        COSINE_WORD;

    }
}

