/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer.tools;

import org.genericsystem.reinforcer.tools.GSPoint;

public class GSSize {
    private double width;
    private double height;

    public GSSize(double width, double height) {
        this.width = width;
        this.height = height;
    }

    public GSSize() {
        this(0.0, 0.0);
    }

    public GSSize(GSPoint p) {
        this.width = p.getX();
        this.height = p.getY();
    }

    public GSSize(double[] vals) {
        this.set(vals);
    }

    private void set(double[] vals) {
        if (vals != null) {
            this.width = vals.length > 0 ? vals[0] : 0.0;
            this.height = vals.length > 1 ? vals[1] : 0.0;
        } else {
            this.width = 0.0;
            this.height = 0.0;
        }
    }

    public double area() {
        return this.width * this.height;
    }

    public boolean empty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public GSSize clone() {
        return new GSSize(this.width, this.height);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GSSize)) {
            return false;
        }
        GSSize it = (GSSize)obj;
        return this.width == it.width && this.height == it.height;
    }

    public String toString() {
        return (int)this.width + "x" + (int)this.height;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }
}

