/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import java.util.List;
import java.util.stream.Collectors;
import org.genericsystem.reinforcer.Alignment;
import org.genericsystem.reinforcer.Direction;
import org.genericsystem.reinforcer.Label;
import org.genericsystem.reinforcer.Labels;
import org.genericsystem.reinforcer.PagePart;
import org.genericsystem.reinforcer.tools.StringCompare;

public interface Constraint {
    public boolean check(Labels var1);

    public static class ColsConstraint
    implements Constraint {
        private int nbCols;

        public ColsConstraint(Labels labels) {
            this.nbCols = labels.findCols().size();
        }

        @Override
        public boolean check(Labels labels) {
            return labels.findCols().size() == this.nbCols;
        }

        public String toString() {
            return "{ ColsConstraint: " + this.nbCols + " }";
        }
    }

    public static class AlignmentConstraint
    implements Constraint {
        private final Alignment alignment;
        private int min;

        public AlignmentConstraint(Alignment alignment, int min) {
            this.alignment = alignment;
            this.min = min;
        }

        @Override
        public boolean check(Labels labels) {
            List<List<Label>> grouped = labels.groupAlignedLabels(this.alignment);
            return grouped.stream().anyMatch(group -> group.size() >= this.min);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.alignment == null ? 0 : this.alignment.hashCode());
            result = 31 * result + this.min;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            AlignmentConstraint other = (AlignmentConstraint)obj;
            return this.alignment == other.alignment && this.min == other.min;
        }

        public String toString() {
            return "alignment: " + (Object)((Object)this.alignment) + ", min: " + this.min;
        }
    }

    public static class RelationConstraint
    extends PositionConstraint {
        private Direction direction;
        private String targetContents;

        public RelationConstraint(PagePart pagePart, String sourceContents, Direction direction, String targetContents) {
            super(pagePart, sourceContents);
            this.direction = direction;
            this.targetContents = targetContents;
        }

        public RelationConstraint(PagePart pagePart, String sourceContents, Direction direction) {
            super(pagePart, sourceContents);
            this.direction = direction;
        }

        @Override
        public boolean check(Labels labels) {
            List<Label> sources = super.getMatchingLabels(labels);
            if (sources.isEmpty()) {
                return false;
            }
            for (Label source : sources) {
                List<Label> possibleTargets = labels.getNeighbors(source, this.direction);
                if (this.targetContents == null) {
                    return !possibleTargets.isEmpty();
                }
                for (Label target : possibleTargets) {
                    if (!target.matchesText(this.targetContents)) continue;
                    return true;
                }
            }
            return false;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            RelationConstraint other = (RelationConstraint)obj;
            return this.pagePart == other.pagePart && StringCompare.similar(this.contents, other.contents, StringCompare.SIMILARITY.LEVENSHTEIN) && (this.targetContents == null && other.targetContents == null || StringCompare.similar(this.targetContents, other.targetContents, StringCompare.SIMILARITY.LEVENSHTEIN));
        }

        @Override
        public String toString() {
            return super.toString() + ", direction: " + (Object)((Object)this.direction) + (this.targetContents == null ? "" : ", target: " + this.targetContents);
        }
    }

    public static class PositionConstraint
    implements Constraint {
        protected PagePart pagePart;
        protected String contents;

        public PositionConstraint(PagePart pagePart, String contents) {
            this.pagePart = pagePart;
            this.contents = contents;
        }

        @Override
        public boolean check(Labels labels) {
            return labels.stream().anyMatch(label -> labels.getPosition((Label)label) == this.pagePart && label.matchesText(this.contents));
        }

        public List<Label> getMatchingLabels(Labels labels) {
            return labels.stream().filter(label -> labels.getPosition((Label)label) == this.pagePart && label.matchesText(this.contents)).collect(Collectors.toList());
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            PositionConstraint other = (PositionConstraint)obj;
            return this.pagePart == other.pagePart && StringCompare.similar(this.contents, other.contents, StringCompare.SIMILARITY.LEVENSHTEIN);
        }

        public int hashCode() {
            return this.pagePart.hashCode();
        }

        public String toString() {
            return "pagePart: " + (Object)((Object)this.pagePart) + ", contents: " + this.contents;
        }
    }
}

