/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import java.util.Collection;
import org.genericsystem.reinforcer.Label;
import org.genericsystem.reinforcer.Labels;
import org.genericsystem.reinforcer.Template3;
import org.genericsystem.reinforcer.tools.GSRect;

public class AffineTransformation {
    protected final double xScale;
    protected final double xShift;
    protected final double yScale;
    protected final double yShift;

    public AffineTransformation(Template3.Match match) {
        GSRect rect1 = match.source.getRect();
        GSRect rect2 = match.match.getRect();
        double[] xParams = this.solve(rect1.getX(), rect2.getX(), rect1.getX() + rect1.getWidth(), rect2.getX() + rect2.getWidth());
        double[] yParams = this.solve(rect1.getY(), rect2.getY(), rect1.getY() + rect1.getHeight(), rect2.getY() + rect2.getHeight());
        this.xScale = xParams[0];
        this.xShift = xParams[1];
        this.yScale = yParams[0];
        this.yShift = yParams[1];
    }

    public AffineTransformation(Collection<Template3.Match> matches) {
        if (matches.isEmpty()) {
            throw new IllegalStateException("Can not compute transformation from an empty collection of matches.");
        }
        double xScale = 0.0;
        double xShift = 0.0;
        double yScale = 0.0;
        double yShift = 0.0;
        int count = 0;
        for (Template3.Match match : matches) {
            AffineTransformation matchTransform = new AffineTransformation(match);
            xScale = ((double)(++count - 1) * xScale + matchTransform.xScale) / (double)count;
            xShift = ((double)(count - 1) * xShift + matchTransform.xShift) / (double)count;
            yScale = ((double)(count - 1) * yScale + matchTransform.yScale) / (double)count;
            yShift = ((double)(count - 1) * yShift + matchTransform.yShift) / (double)count;
        }
        this.xScale = xScale;
        this.xShift = xShift;
        this.yScale = yScale;
        this.yShift = yShift;
    }

    private double[] solve(double xs1, double xt1, double xs2, double xt2) {
        if (xs1 == xs2) {
            throw new IllegalStateException("The given points must be distinct.");
        }
        double a = (xt2 - xt1) / (xs2 - xs1);
        double b = xt1 - a * xs1;
        return new double[]{a, b};
    }

    public Labels transform(Labels labels) {
        Labels transformed = new Labels();
        for (Label label : labels) {
            transformed.addLabel(label.affineTransform(this.xScale, this.xShift, this.yScale, this.yShift));
        }
        return transformed;
    }

    public double computeError(Template3.Match match) {
        AffineTransformation matchTransform = new AffineTransformation(match);
        return this.square(this.xScale - matchTransform.xScale) + this.square(this.xShift - matchTransform.xShift) + this.square(this.yScale - matchTransform.yScale) + this.square(this.yShift - matchTransform.yShift);
    }

    private double square(double x) {
        return x * x;
    }
}

