/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer.tools;

public class Levenshtein {
    public static int distance(String a, String b) {
        int i;
        if (null == a || null == b) {
            throw new IllegalArgumentException("Levenshtein distance requires two not null strings");
        }
        if (a.equals(b)) {
            return 0;
        }
        if (a.isEmpty()) {
            return b.length();
        }
        if (b.isEmpty()) {
            return a.length();
        }
        a = a.toLowerCase();
        b = b.toLowerCase();
        int[] costs = new int[b.length() + 1];
        for (i = 0; i < costs.length; ++i) {
            costs[i] = i;
        }
        for (i = 1; i <= a.length(); ++i) {
            costs[0] = i;
            int nw = i - 1;
            for (int j = 1; j <= b.length(); ++j) {
                int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), a.charAt(i - 1) == b.charAt(j - 1) ? nw : nw + 1);
                nw = costs[j];
                costs[j] = cj;
            }
        }
        return costs[b.length()];
    }

    public static double similarity(String string1, String string2) {
        return 1.0 - Levenshtein.normedDistance(string1, string2);
    }

    public static double normedDistance(String string1, String string2) {
        return (double)Levenshtein.distance(string1, string2) / (double)Math.max(string1.length(), string2.length());
    }
}

