/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.genericsystem.reinforcer.tools.GSPoint;
import org.genericsystem.reinforcer.tools.GSRect;

public class RectangleTools {
    public static final double DEFAULT_EPSILON = 0.2;
    public static final double DEFAULT_GROUP_THRESHOLD = 0.0;

    public static List<GSRect> groupRectangles(List<GSRect> input, MERGE_METHOD method) {
        return RectangleTools.groupRectangles(input, 0.2, 0.0, method);
    }

    public static List<GSRect> groupRectangles(List<GSRect> input, double eps, double groupThreshold, MERGE_METHOD method) {
        Function<List, GSRect> merge;
        List<List> filtered = RectangleTools.cluster(input, eps).stream().filter(sublist -> (double)sublist.size() > groupThreshold).collect(Collectors.toList());
        ConcurrentHashMap map = new ConcurrentHashMap();
        switch (method) {
            case UNION: {
                merge = list -> list.size() <= 1 ? (GSRect)list.get(0) : (GSRect)list.stream().reduce(list.get(0), (r, total) -> r.getUnion((GSRect)total));
                break;
            }
            case INTERSECTION: {
                merge = list -> list.size() <= 1 ? (GSRect)list.get(0) : (GSRect)list.stream().reduce(list.get(0), (r, total) -> r.getIntersection((GSRect)total));
                break;
            }
            default: {
                merge = list -> list.size() <= 1 ? (GSRect)list.get(0) : RectangleTools.getMean(list);
            }
        }
        filtered.forEach(clustered -> map.put(merge.apply((List)clustered), clustered.size()));
        Iterator outerIt = map.entrySet().iterator();
        block4: while (outerIt.hasNext()) {
            Map.Entry outer = outerIt.next();
            Iterator innerIt = map.entrySet().iterator();
            while (innerIt.hasNext()) {
                Optional<GSRect> match;
                Map.Entry entry2 = innerIt.next();
                if (outer.equals(entry2) || !(match = RectangleTools.group((GSRect)outer.getKey(), (Integer)outer.getValue(), (GSRect)entry2.getKey(), (Integer)entry2.getValue(), eps)).isPresent()) continue;
                GSRect rect = match.get();
                if (((GSRect)entry2.getKey()).equals(rect)) {
                    innerIt.remove();
                    continue;
                }
                outerIt.remove();
                continue block4;
            }
        }
        return map.entrySet().stream().map(entry -> (GSRect)entry.getKey()).collect(Collectors.toList());
    }

    public static List<List<GSRect>> cluster(List<GSRect> input, double eps) {
        ArrayList<GSRect> copy = new ArrayList<GSRect>(input);
        ArrayList<List<GSRect>> output = new ArrayList<List<GSRect>>();
        while (copy.size() > 0) {
            GSRect first = (GSRect)copy.get(0);
            ArrayList<GSRect> clustered = new ArrayList<GSRect>();
            clustered.add(first);
            for (GSRect r : copy) {
                if (r.equals(first) || !RectangleTools.isInCluster(first, r, eps)) continue;
                clustered.add(r);
            }
            output.add(clustered);
            copy.removeAll(clustered);
        }
        return output;
    }

    public static boolean isInCluster(GSRect rect1, GSRect rect2, double eps, int sides) {
        double delta = RectangleTools.getDelta(rect1, rect2, eps);
        boolean left = Math.abs(rect1.tl().getX() - rect2.tl().getX()) <= delta;
        boolean top = Math.abs(rect1.tl().getY() - rect2.tl().getY()) <= delta;
        boolean right = Math.abs(rect1.br().getX() - rect2.br().getX()) <= delta;
        boolean bottom = Math.abs(rect1.br().getY() - rect2.br().getY()) <= delta;
        switch (sides) {
            default: {
                return left && top && right && bottom;
            }
            case 3: {
                return left && top && right || left && top && bottom || right && bottom && left || right && bottom && top;
            }
            case 2: {
                return left && top || left && right || left && bottom || top && right || top && bottom || right && bottom;
            }
            case 1: 
        }
        return left || top || right || bottom;
    }

    public static boolean isInCluster(GSRect rect1, GSRect rect2, double eps) {
        return RectangleTools.isInCluster(rect1, rect2, eps, 4);
    }

    private static double getDelta(GSRect rect1, GSRect rect2, double eps) {
        return eps * (Math.min(rect1.getWidth(), rect2.getWidth()) + Math.min(rect1.getHeight(), rect2.getHeight())) / 2.0;
    }

    private static Optional<GSRect> group(GSRect rect1, int count1, GSRect rect2, int count2, double eps) {
        int smallerCount;
        GSRect smaller;
        int biggerCount;
        GSRect bigger;
        if (rect1.area() > rect2.area()) {
            bigger = rect1;
            biggerCount = count1;
            smaller = rect2;
            smallerCount = count2;
        } else {
            bigger = rect2;
            biggerCount = count2;
            smaller = rect1;
            smallerCount = count1;
        }
        double dx = eps * bigger.getWidth();
        double dy = eps * bigger.getHeight();
        boolean res = smaller.tl().getX() >= bigger.tl().getX() - dx;
        res = res && smaller.tl().getY() >= bigger.tl().getY() - dy;
        res = res && smaller.br().getX() <= bigger.br().getX() + dx;
        res = res && smaller.br().getY() <= bigger.br().getY() + dy;
        boolean bl = res = res && (biggerCount > Math.max(3, smallerCount) || smallerCount < 3);
        if (res) {
            return Optional.of(smaller);
        }
        return Optional.empty();
    }

    public static double[] commonArea(GSRect rect1, GSRect rect2) {
        double[] result = new double[2];
        GSRect intersection = rect1.getIntersection(rect2);
        if (intersection != null) {
            result[0] = intersection.area() / rect1.area();
            result[1] = intersection.area() / rect2.area();
        } else {
            result[0] = 0.0;
            result[1] = 0.0;
        }
        return result;
    }

    public static GSRect getMean(List<GSRect> rects) {
        if (rects == null || rects.isEmpty()) {
            throw new IllegalArgumentException("Unable to compute mean on a null or empty list");
        }
        if (rects.size() == 1) {
            return rects.get(0);
        }
        double tlx = 0.0;
        double tly = 0.0;
        double brx = 0.0;
        double bry = 0.0;
        for (GSRect r : rects) {
            tlx += r.tl().getX();
            tly += r.tl().getY();
            brx += r.br().getX();
            bry += r.br().getY();
        }
        return new GSRect(new GSPoint(tlx /= (double)rects.size(), tly /= (double)rects.size()), new GSPoint(brx /= (double)rects.size(), bry /= (double)rects.size()));
    }

    public static List<GSRect> nonMaximumSuppression(List<GSRect> boxes, double overlapThreshold) {
        if (boxes == null || boxes.size() == 0) {
            return Collections.emptyList();
        }
        ArrayList<Integer> pick = new ArrayList<Integer>();
        List x1 = boxes.stream().map(rect -> rect.tl().getX()).collect(Collectors.toList());
        List y1 = boxes.stream().map(rect -> rect.tl().getY()).collect(Collectors.toList());
        List x2 = boxes.stream().map(rect -> rect.br().getX()).collect(Collectors.toList());
        List y2 = boxes.stream().map(rect -> rect.br().getY()).collect(Collectors.toList());
        List area = boxes.stream().map(rect -> rect.area()).collect(Collectors.toList());
        List indx = IntStream.range(0, y2.size()).boxed().sorted((i, j) -> Double.compare((Double)y2.get((int)i), (Double)y2.get((int)j))).collect(Collectors.toList());
        long count = 0L;
        while (indx.size() > 0 && count++ < (long)(10 * boxes.size())) {
            int last = indx.size() - 1;
            int i2 = (Integer)indx.get(last);
            pick.add(i2);
            List xx1 = IntStream.range(0, x1.size()).filter(idx -> indx.contains(idx)).mapToObj(x1::get).map(x -> Math.max((Double)x1.get(i2), x)).collect(Collectors.toList());
            List yy1 = IntStream.range(0, y1.size()).filter(idx -> indx.contains(idx)).mapToObj(y1::get).map(y -> Math.max((Double)y1.get(i2), y)).collect(Collectors.toList());
            List xx2 = IntStream.range(0, x2.size()).filter(idx -> indx.contains(idx)).mapToObj(x2::get).map(x -> Math.min((Double)x2.get(i2), x)).collect(Collectors.toList());
            List yy2 = IntStream.range(0, y2.size()).filter(idx -> indx.contains(idx)).mapToObj(y2::get).map(y -> Math.min((Double)y2.get(i2), y)).collect(Collectors.toList());
            ArrayList<Double> width = new ArrayList<Double>();
            ArrayList<Double> height = new ArrayList<Double>();
            ArrayList<Double> overlap = new ArrayList<Double>();
            List filteredArea = IntStream.range(0, area.size()).filter(idx -> indx.contains(idx)).mapToObj(area::get).collect(Collectors.toList());
            for (int j2 = 0; j2 < xx1.size(); ++j2) {
                width.add(Math.max(0.0, (Double)xx2.get(j2) - (Double)xx1.get(j2) + 1.0));
                height.add(Math.max(0.0, (Double)yy2.get(j2) - (Double)yy1.get(j2) + 1.0));
                overlap.add((Double)width.get(j2) * (Double)height.get(j2) / (Double)filteredArea.get(j2));
            }
            IntStream.range(0, overlap.size()).filter(idx -> (Double)overlap.get(idx) > overlapThreshold).boxed().forEach(idx -> indx.remove(idx));
        }
        List<GSRect> res = IntStream.range(0, boxes.size()).filter(idx -> pick.contains(idx)).mapToObj(boxes::get).collect(Collectors.toList());
        return res;
    }

    public static GSRect linearCombination(GSRect rect1, double n1, GSRect rect2, double n2) {
        return new GSRect(n1 * rect1.getX() + n2 * rect2.getX(), n1 * rect1.getY() + n2 * rect2.getY(), n1 * rect1.getWidth() + n2 * rect2.getWidth(), n1 * rect1.getHeight() + n2 * rect2.getHeight());
    }

    public static enum MERGE_METHOD {
        UNION,
        INTERSECTION,
        MEAN;

    }
}

