/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.genericsystem.reinforcer.Constraint;
import org.genericsystem.reinforcer.Labels;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template2 {
    private final Logger logger = LoggerFactory.getLogger(Template2.class);
    private final String name;
    protected final Set<Labels> confirmedMembers = new HashSet<Labels>();
    protected final Set<Labels> otherMembers = new HashSet<Labels>();
    private List<Constraint> constraints = new ArrayList<Constraint>();

    public Template2(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(Labels entry) {
        return this.constraints.stream().allMatch(constraint -> constraint.check(entry));
    }

    public void addConfirmedMember(Labels labels) {
        this.confirmedMembers.add(labels);
    }

    public void addLabels(Labels labels) {
        this.confirmedMembers.add(labels);
    }

    public boolean contains(Labels al) {
        return this.confirmedMembers.contains(al) || this.otherMembers.contains(al);
    }

    public boolean contains(Constraint constraint) {
        return this.constraints.contains(constraint);
    }

    public boolean isCompatibleWith(Constraint constraint) {
        return this.confirmedMembers.stream().allMatch(member -> constraint.check((Labels)member));
    }

    public void addConstraint(Constraint constraint) {
        this.constraints.add(constraint);
    }

    public void addConstraintExcluding(Labels exclude) {
        ArrayList<Labels> members = new ArrayList<Labels>(this.confirmedMembers);
        Set<Constraint> compatibleConstraints = this.computePossibleAdds((Labels)members.get(0));
        for (int i = 1; i < this.confirmedMembers.size(); ++i) {
            Set<Constraint> newConstraints = this.computePossibleAdds((Labels)members.get(i));
            compatibleConstraints.retainAll(newConstraints);
        }
        if (compatibleConstraints.isEmpty()) {
            throw new IllegalStateException("Impossible to specialize template " + this.name + " to exclude item " + exclude);
        }
        List<Constraint> possibleAdds = compatibleConstraints.stream().filter(constraint -> !constraint.check(exclude)).collect(Collectors.toList());
        if (possibleAdds.isEmpty()) {
            throw new IllegalStateException("Impossible to specialize template " + this.name + " to exclude item " + exclude);
        }
        this.addConstraintFrom(possibleAdds);
    }

    public void addConstraintIncluding(Labels include) {
        Set<Constraint> possibleAdds = this.computePossibleAdds(include);
        if (possibleAdds.isEmpty()) {
            throw new IllegalStateException("Impossible to specialize the model for " + this.name + " to accomodate the new item.");
        }
        this.addConstraintFrom(new ArrayList<Constraint>(possibleAdds));
        this.addConfirmedMember(include);
    }

    public void removeConstraintToInclude(Labels include) {
        Iterator<Constraint> it = this.constraints.iterator();
        while (it.hasNext()) {
            Constraint constraint = it.next();
            if (constraint.check(include)) continue;
            it.remove();
        }
        this.addConfirmedMember(include);
    }

    public void addConstraintFrom(List<Constraint> constraints) {
        List relC = constraints.stream().filter(c -> c instanceof Constraint.RelationConstraint).map(c -> (Constraint.RelationConstraint)c).collect(Collectors.toList());
        if (!relC.isEmpty()) {
            this.addConstraint((Constraint)relC.get(0));
        } else {
            List posC = constraints.stream().filter(c -> c instanceof Constraint.PositionConstraint).map(c -> (Constraint.PositionConstraint)c).collect(Collectors.toList());
            if (!posC.isEmpty()) {
                this.addConstraint((Constraint)posC.get(0));
            } else {
                this.addConstraint(constraints.get(0));
            }
        }
    }

    public Set<Constraint> computePossibleAdds(Labels item) {
        return item.getConstraints().stream().filter(constraint -> !this.contains((Constraint)constraint) && this.isCompatibleWith((Constraint)constraint)).collect(Collectors.toSet());
    }

    public boolean hasConstraints() {
        return !this.constraints.isEmpty();
    }

    public String toString() {
        return "\nTemplate " + this.name + "\nConstraints: " + this.constraints;
    }
}

