/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.genericsystem.reinforcer.Labels;
import org.genericsystem.reinforcer.Template2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Reinforcer2 {
    private final Logger logger = LoggerFactory.getLogger(Reinforcer2.class);
    private final List<Template2> templates = new ArrayList<Template2>();

    public void forceTemplate(Labels labels, String templateName) {
        this.logger.debug("Force template {}, labels: {}", (Object)templateName, (Object)labels);
        List<Template2> matching = this.getMatchingTemplates(labels);
        if (matching.size() == 1 && matching.get(0).getName().equals(templateName)) {
            if (!matching.get(0).hasConstraints()) {
                matching.get(0).addConstraintIncluding(labels);
            } else {
                return;
            }
        }
        Template2 template = this.templates.stream().filter(t -> t.getName().equals(templateName)).findFirst().orElse(null);
        matching.stream().filter(t -> !t.getName().equals(templateName)).forEach(otherTemplate -> otherTemplate.addConstraintExcluding(labels));
        if (template == null) {
            template = new Template2(templateName);
            this.templates.add(template);
            template.addConfirmedMember(labels);
        } else if (matching.stream().allMatch(t -> !t.getName().equals(templateName))) {
            template.removeConstraintToInclude(labels);
            for (Template2 other : this.templates) {
                for (Labels exclude : other.confirmedMembers) {
                    if (!template.matches(exclude)) continue;
                    template.addConstraintExcluding(exclude);
                }
            }
        }
    }

    public List<Template2> getMatchingTemplates(Labels labels) {
        return this.templates.stream().filter(t -> t.matches(labels)).collect(Collectors.toList());
    }

    public String getTemplate(Labels labels) {
        List<Template2> matching = this.getMatchingTemplates(labels);
        if (matching.isEmpty()) {
            throw new IllegalStateException("No template found for " + labels);
        }
        if (matching.size() > 1) {
            throw new IllegalStateException("Multiple templates found for " + labels);
        }
        return matching.get(0).getName();
    }

    public String toString() {
        return this.templates.toString();
    }
}

