/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer.tools;

import org.genericsystem.reinforcer.tools.GSRect;

public class GSPoint
implements Comparable<GSPoint> {
    private double x;
    private double y;

    public GSPoint(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public GSPoint() {
        this(0.0, 0.0);
    }

    public GSPoint(double[] vals) {
        this();
        this.set(vals);
    }

    private void set(double[] vals) {
        if (vals != null) {
            this.x = vals.length > 0 ? vals[0] : 0.0;
            this.y = vals.length > 1 ? vals[1] : 0.0;
        } else {
            this.x = 0.0;
            this.y = 0.0;
        }
    }

    public GSPoint clone() {
        return new GSPoint(this.x, this.y);
    }

    public double dot(GSPoint p) {
        return this.x * p.x + this.y * p.y;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GSPoint)) {
            return false;
        }
        GSPoint it = (GSPoint)obj;
        return this.x == it.x && this.y == it.y;
    }

    public boolean inside(GSRect r) {
        return r.contains(this);
    }

    public String toString() {
        return "{" + this.x + ", " + this.y + "}";
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    @Override
    public int compareTo(GSPoint o) {
        if (this.y != o.y) {
            return (int)Math.signum(o.y - this.y);
        }
        if (this.x != o.x) {
            return (int)Math.signum(o.x - this.x);
        }
        return 0;
    }
}

