/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import java.util.ArrayList;
import java.util.List;
import org.genericsystem.reinforcer.DetectedContent;
import org.genericsystem.reinforcer.Labels;
import org.genericsystem.reinforcer.Template3;

public class Extractor {
    private final List<Template3> templates = new ArrayList<Template3>();

    public void reinforce(Labels labels, String templateName) {
        Template3 template = this.templates.stream().filter(t -> t.getName().equals(templateName)).findFirst().orElse(null);
        if (template == null) {
            template = new Template3(templateName);
            this.templates.add(template);
        }
        template.reinforce(labels);
    }

    public List<DetectedContent> extractData(Labels labels, String templateName) {
        Template3 template = this.templates.stream().filter(t -> t.getName().equals(templateName)).findFirst().orElse(null);
        if (template == null) {
            throw new IllegalStateException("Inexistent template " + templateName);
        }
        return template.extractData(labels);
    }

    public String toString() {
        return this.templates.toString();
    }
}

