/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer.tools;

import com.fasterxml.jackson.annotation.JsonIgnore;
import org.genericsystem.reinforcer.NormalizedRect;
import org.genericsystem.reinforcer.tools.GSPoint;
import org.genericsystem.reinforcer.tools.GSSize;

public class GSRect
implements Comparable<GSRect> {
    private double x;
    private double y;
    private double width;
    private double height;

    public GSRect(double x, double y, double width, double height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public GSRect() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    public GSRect(GSPoint p1, GSPoint p2) {
        this.x = p1.getX() < p2.getX() ? p1.getX() : p2.getX();
        this.y = p1.getY() < p2.getY() ? p1.getY() : p2.getY();
        this.width = (p1.getX() > p2.getX() ? p1.getX() : p2.getX()) - this.x;
        this.height = (p1.getY() > p2.getY() ? p1.getY() : p2.getY()) - this.y;
    }

    public GSRect(GSPoint p, GSSize s) {
        this(p.getX(), p.getY(), s.getWidth(), s.getHeight());
    }

    public GSRect(double[] vals) {
        this.set(vals);
    }

    private void set(double[] vals) {
        if (vals != null) {
            this.x = vals.length > 0 ? vals[0] : 0.0;
            this.y = vals.length > 1 ? vals[1] : 0.0;
            this.width = vals.length > 2 ? vals[2] : 0.0;
            this.height = vals.length > 3 ? vals[3] : 0.0;
        } else {
            this.x = 0.0;
            this.y = 0.0;
            this.width = 0.0;
            this.height = 0.0;
        }
    }

    public GSRect clone() {
        return new GSRect(this.x, this.y, this.width, this.height);
    }

    public GSPoint tl() {
        return new GSPoint(this.x, this.y);
    }

    public GSPoint br() {
        return new GSPoint(this.x + this.width, this.y + this.height);
    }

    public GSSize size() {
        return new GSSize(this.width, this.height);
    }

    public double area() {
        return this.width * this.height;
    }

    public boolean empty() {
        return this.width <= 0.0 || this.height <= 0.0;
    }

    public boolean contains(GSPoint p) {
        return this.x <= p.getX() && p.getX() <= this.x + this.width && this.y <= p.getY() && p.getY() <= this.y + this.height;
    }

    public double inclusiveArea(GSRect rect2) {
        if (rect2 == null) {
            return 0.0;
        }
        GSRect intersection = this.getIntersection(rect2);
        if (intersection == null) {
            return 0.0;
        }
        GSRect union = this.getUnion(rect2);
        return intersection.area() / union.area();
    }

    public GSRect getIntersection(GSRect rect2) {
        GSRect insider = this.getInsider(rect2);
        if (insider != null) {
            return insider;
        }
        double tlX = Math.max(this.tl().getX(), rect2.tl().getX());
        double tlY = Math.max(this.tl().getY(), rect2.tl().getY());
        double brX = Math.min(this.br().getX(), rect2.br().getX());
        double brY = Math.min(this.br().getY(), rect2.br().getY());
        return brX - tlX <= 0.0 || brY - tlY <= 0.0 ? null : new GSRect(new GSPoint(tlX, tlY), new GSPoint(brX, brY));
    }

    public GSRect getUnion(GSRect rect2) {
        return new GSRect(new GSPoint(Math.min(this.tl().getX(), rect2.tl().getX()), Math.min(this.tl().getY(), rect2.tl().getY())), new GSPoint(Math.max(this.br().getX(), rect2.br().getX()), Math.max(this.br().getY(), rect2.br().getY())));
    }

    public boolean isOverlapping(GSRect other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("One of the rectangles is null");
        }
        return this.x <= other.br().getX() && other.tl().getX() <= this.br().getX() && this.y <= other.br().getY() && other.tl().getY() <= this.br().getY();
    }

    public boolean isOverlappingStrict(GSRect other) throws IllegalArgumentException {
        if (other == null) {
            throw new IllegalArgumentException("One of the rectangles is null");
        }
        return this.x < other.br().getX() && other.tl().getX() < this.br().getX() && this.y < other.br().getY() && other.tl().getY() < this.br().getY();
    }

    public GSRect getInsider(GSRect rect2) {
        GSPoint[] points1 = this.decomposeClockwise();
        GSPoint[] points2 = rect2.decomposeClockwise();
        boolean isGSRect2InGSRect1 = true;
        boolean isGSRect1InGSRect2 = true;
        for (GSPoint p : points2) {
            if (this.contains(p)) continue;
            isGSRect2InGSRect1 = false;
        }
        if (!isGSRect2InGSRect1) {
            for (GSPoint p : points1) {
                if (rect2.contains(p)) continue;
                isGSRect1InGSRect2 = false;
            }
            if (isGSRect1InGSRect2) {
                return this;
            }
            return null;
        }
        return rect2;
    }

    public boolean isInside(GSRect other) {
        GSRect insider = this.getInsider(other);
        return insider != null && insider != other;
    }

    public boolean isNearEdge(int width, int height, int tolerance) {
        return this.x <= (double)tolerance || this.y <= (double)tolerance || this.x + this.width >= (double)(width - tolerance) || this.y + this.height >= (double)(height - tolerance);
    }

    public GSPoint[] decomposeClockwise() {
        GSPoint[] points = new GSPoint[]{this.tl(), new GSPoint(this.br().getX(), this.tl().getY()), this.br(), new GSPoint(this.tl().getX(), this.br().getY())};
        return points;
    }

    public double diffWith(GSRect rect2, double eps) {
        return Math.max(Math.max(Math.abs(this.x - rect2.tl().getX()), Math.abs(this.y - rect2.tl().getY())), Math.max(Math.abs(this.br().getX() - rect2.br().getX()), Math.abs(this.br().getY() - rect2.br().getY())));
    }

    public NormalizedRect normalize(double mintlx, double mintly, double width, double height) {
        return new NormalizedRect((this.x - mintlx) / width, (this.y - mintly) / height, this.width / width, this.height / height);
    }

    public boolean hOverlaps(GSRect other) {
        return other.br().getX() >= this.x && other.x < this.br().getX();
    }

    public boolean vOverlaps(GSRect other) {
        return other.br().getY() >= this.y && other.y < this.br().getY();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.height);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.width);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof GSRect)) {
            return false;
        }
        GSRect it = (GSRect)obj;
        return this.x == it.x && this.y == it.y && this.width == it.width && this.height == it.height;
    }

    public String toString() {
        return String.format("{GSRect, tlx: %,.1f, tly: %,.1f, width: %,.1f, height: %,.1f}", this.x, this.y, this.width, this.height);
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public void setX(double x) {
        this.x = x;
    }

    public void setY(double y) {
        this.y = y;
    }

    public void setWidth(double width) {
        this.width = width;
    }

    public void setHeight(double height) {
        this.height = height;
    }

    @JsonIgnore
    public GSPoint getCenter() {
        return new GSPoint(this.x + this.width / 2.0, this.y + this.height / 2.0);
    }

    @Override
    public int compareTo(GSRect o) {
        return this.getCenter().compareTo(o.getCenter());
    }
}

