/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.genericsystem.reinforcer.Constraint;
import org.genericsystem.reinforcer.DetectedContent;
import org.genericsystem.reinforcer.Direction;
import org.genericsystem.reinforcer.Label;
import org.genericsystem.reinforcer.Labels;
import org.genericsystem.reinforcer.tools.StringCompare;

public class Template3 {
    private final String name;
    protected final List<Labels> members = new ArrayList<Labels>();
    private List<Constraint> constraints = new ArrayList<Constraint>();
    private List<LabelDesc> description = new ArrayList<LabelDesc>();

    public Template3(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean matches(Labels entry) {
        return this.constraints.stream().allMatch(constraint -> constraint.check(entry));
    }

    public void addLabels(Labels labels) {
        this.members.add(labels);
    }

    public boolean contains(Labels al) {
        return this.members.contains(al);
    }

    private void buildTemplate() {
        if (this.members.size() < 2) {
            throw new IllegalStateException("There must be at least two examples for the template to be built.");
        }
        Labels labels1 = this.members.get(0);
        Labels labels2 = this.members.get(1);
        List<Match> bestAligned = labels2.alignWith(labels1);
        for (Match match : bestAligned) {
            if (match.source == null || match.match == null || !StringCompare.similar(match.source.getText(), match.match.getText(), StringCompare.SIMILARITY.LEVENSHTEIN)) continue;
            this.description.add(new LabelDesc(match.match));
        }
        this.description.forEach(ld -> ld.setDirection(labels1.contentDirection(ld.getLabel(), this.description)));
    }

    private void reinforceTemplate(Labels absoluteLabels) {
        Iterator<LabelDesc> it = this.description.iterator();
        while (it.hasNext()) {
            LabelDesc descriptor = it.next();
            if (absoluteLabels.toList().stream().map(label -> label.getText()).anyMatch(c -> StringCompare.similar(c, descriptor.getLabel().getText(), StringCompare.SIMILARITY.LEVENSHTEIN))) continue;
            it.remove();
        }
    }

    public List<DetectedContent> extractData(Labels labels) {
        Labels ref = new Labels();
        this.description.forEach(ld -> ref.addLabel(ld.getLabel()));
        List<Match> matched = labels.alignWith(ref);
        Labels aligned = new Labels();
        matched.forEach(match -> {
            if (match.source != null) {
                aligned.addLabel(match.source);
            }
        });
        ArrayList<DetectedContent> result = new ArrayList<DetectedContent>();
        for (Match match2 : matched) {
            Label target;
            LabelDesc ld2;
            if (match2.source == null || match2.match == null || (ld2 = (LabelDesc)this.description.stream().filter(ref.getTest.apply(match2.match)).findFirst().orElse(null)) == null || (target = aligned.getDirectNeighbor(match2.source, ld2.direction)) == null) continue;
            result.add(new DetectedContent(match2.match.getText(), target.getText()));
        }
        return result;
    }

    public void reinforce(Labels absoluteLabels) {
        this.members.add(absoluteLabels);
        if (this.members.size() == 2) {
            this.buildTemplate();
        }
        if (this.members.size() > 2) {
            this.reinforceTemplate(absoluteLabels);
        }
    }

    public String toString() {
        return "\nTemplate " + this.name + "\nConstraints: " + this.constraints;
    }

    public static class LabelDesc {
        private Label label;
        private Direction direction;

        public LabelDesc(Label label) {
            this.label = label;
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public Label getLabel() {
            return this.label;
        }

        public String toString() {
            return "{LabelDesc " + this.label.toString() + ", content direction: " + (Object)((Object)this.direction) + "}";
        }
    }

    public static class Match {
        Label source;
        Label match;

        public Match(Label source, Label match) {
            this.source = source;
            this.match = match;
        }

        public String toString() {
            return "\n{ Match between " + this.source + " and " + this.match + " }";
        }
    }
}

