/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reinforcer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.genericsystem.reinforcer.Label;
import org.genericsystem.reinforcer.Labels;
import org.genericsystem.reinforcer.tools.GSRect;
import org.genericsystem.reinforcer.tools.RectangleTools;
import org.genericsystem.reinforcer.tools.StringCompare;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Template {
    private final Logger logger = LoggerFactory.getLogger(Template.class);
    protected final Set<Labels> contents = new HashSet<Labels>();
    private List<LabelDesc> description = new ArrayList<LabelDesc>();
    private int nbExamples = 1;

    public Template(Labels labels) {
        Labels normalized = labels.normalizeLabels();
        this.contents.add(normalized);
        for (Label label : normalized) {
            this.description.add(new LabelDesc(label, 1.0, 1.0));
        }
    }

    public double getMatchRate(Labels others) {
        Labels normalized = others.normalizeLabels();
        Map<LabelDesc, List<Label>> closest = this.getClosestMap(normalized);
        double total = 0.0;
        if (normalized.size() == this.description.size() && closest.values().stream().allMatch(l -> l.size() == 1)) {
            total = closest.entrySet().stream().map(entry -> ((LabelDesc)entry.getKey()).matchRate((Label)((List)entry.getValue()).get(0))).reduce(0.0, Double::sum);
            total /= (double)this.description.size();
        }
        this.logger.debug("============== Template match =================");
        this.logger.debug("template labels: {}", this.description);
        this.logger.debug("other normalized labels: {}", (Object)normalized);
        this.logger.debug("matchRate: {}", (Object)total);
        this.logger.debug("===============================================");
        return total;
    }

    public void addLabels(Labels labels) {
        this.contents.add(labels);
    }

    public boolean contains(Labels al) {
        return this.contents.contains(al);
    }

    public void reinforce(Labels absoluteLabels) {
        ++this.nbExamples;
        Labels normalized = absoluteLabels.normalizeLabels();
        Map<LabelDesc, List<Label>> closest = this.getClosestMap(normalized);
        for (Map.Entry<LabelDesc, List<Label>> entry : closest.entrySet()) {
            if (entry.getValue().size() != 1) continue;
            LabelDesc key = entry.getKey();
            Label matched = entry.getValue().get(0);
            if (RectangleTools.isInCluster(matched.getRect(), key.rect, 0.2)) {
                key.adaptText(matched.getText());
                continue;
            }
            key.adaptPos(matched.getRect(), this.nbExamples);
            key.adaptText(matched.getText());
        }
    }

    private LabelDesc getClosest(Label label) {
        LabelDesc closest = null;
        double minDistance = Double.MAX_VALUE;
        for (LabelDesc desc : this.description) {
            double dist = desc.getRect().diffWith(label.getRect(), 0.2);
            if (!(dist < minDistance)) continue;
            minDistance = dist;
            closest = desc;
        }
        return closest;
    }

    private Map<LabelDesc, List<Label>> getClosestMap(Labels normalized) {
        HashMap<LabelDesc, List<Label>> closest = new HashMap<LabelDesc, List<Label>>();
        for (Label label : normalized) {
            LabelDesc cl = this.getClosest(label);
            if (closest.get(cl) == null) {
                closest.put(cl, Arrays.asList(label));
                continue;
            }
            ((List)closest.get(cl)).add(label);
        }
        return closest;
    }

    public static class LabelDesc {
        private final Logger logger = LoggerFactory.getLogger(LabelDesc.class);
        private GSRect rect;
        private String text;
        private double posWeight;
        private double textWeight;

        public LabelDesc(Label label, double posWeight, double textWeight) {
            this.rect = label.getRect();
            this.text = label.getText();
            this.posWeight = posWeight;
            this.textWeight = textWeight;
        }

        public double matchRate(Label label) {
            double result = this.text != null ? 1.0 - (this.posWeight * this.rect.diffWith(label.getRect(), 0.2) + this.textWeight * (1.0 - StringCompare.compare(this.text, label.getText(), StringCompare.SIMILARITY.LEVENSHTEIN))) / 2.0 : 1.0 - this.posWeight * this.rect.diffWith(label.getRect(), 0.2);
            this.logger.debug("matchrate between label {} and labelDesc {}: {}.", new Object[]{label, this, result});
            return result;
        }

        public void adaptText(String otherText) {
            double levSim = StringCompare.compare(this.text, otherText, StringCompare.SIMILARITY.LEVENSHTEIN);
            if (levSim < 0.1) {
                this.text = null;
                this.textWeight = 0.0;
            }
        }

        public void adaptPos(GSRect otherPos, int nbExamples) {
            this.rect = RectangleTools.linearCombination(this.rect, ((double)nbExamples - 1.0) / (double)nbExamples, otherPos, 1.0 / (double)nbExamples);
        }

        public GSRect getRect() {
            return this.rect;
        }

        public String toString() {
            return "{LabelDesc " + this.rect.toString() + ", content: " + this.text + ", posWeight: " + this.posWeight + ", textWeight: " + this.textWeight + "}";
        }
    }
}

