/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.contextproperties;

import javafx.beans.property.Property;
import javafx.collections.ObservableList;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.contextproperties.ContextProperty;

public interface StepperDefaults
extends ContextProperty {
    public static final String INDEX = "index";
    public static final String INSTANCE_NAME_TAG = "instanceNameTag";
    public static final String STEPPER_TAG = "steppedTag";

    default public Tag getInstanceNameTag(Context context) {
        return (Tag)this.getContextProperty(INSTANCE_NAME_TAG, context).getValue();
    }

    default public Tag getStepperTag(Context context) {
        return (Tag)this.getContextProperty(STEPPER_TAG, context).getValue();
    }

    default public Property<Integer> getIteratorIndexProperty(Context context) {
        return this.getContextProperty(INDEX, context);
    }

    default public void stepper(Tag switchedTag, Tag instanceNameTag) {
        this.addPrefixBinding(context -> {
            this.createNewInitializedProperty(INDEX, (Context)context, -1);
            this.createNewInitializedProperty(INSTANCE_NAME_TAG, (Context)context, instanceNameTag);
            this.createNewInitializedProperty(STEPPER_TAG, (Context)context, switchedTag);
        });
        instanceNameTag.addStyle("display", "flex");
        switchedTag.addPostfixBinding(context -> {
            String cfr_ignored_0 = (String)switchedTag.getDomNodeStyles((Context)context).put((Object)"display", (Object)"none");
        });
    }

    default public void next(Context context) {
        Property<Integer> index = this.getIteratorIndexProperty(context);
        Tag stepperTag = this.getStepperTag(context);
        ObservableList<Context> contexts = context.getSubContexts(stepperTag);
        if (contexts == null) {
            contexts = context.getParent().getSubContexts(stepperTag);
        }
        if ((Integer)index.getValue() == -1) {
            index.setValue((Object)0);
            this.getInstanceNameTag(context).addStyle(context, "display", "none");
            stepperTag.addStyle((Context)contexts.get(0), "display", "flex");
        } else if ((Integer)index.getValue() + 1 < contexts.size()) {
            stepperTag.addStyle((Context)contexts.get(((Integer)index.getValue()).intValue()), "display", "none");
            stepperTag.addStyle((Context)contexts.get((Integer)index.getValue() + 1), "display", "flex");
            index.setValue((Object)((Integer)index.getValue() + 1));
        }
    }

    default public void prev(Context context) {
        Property<Integer> index = this.getIteratorIndexProperty(context);
        Tag stepperTag = this.getStepperTag(context);
        ObservableList<Context> contexts = context.getSubContexts(stepperTag);
        if (contexts == null) {
            contexts = context.getParent().getSubContexts(this.getStepperTag(context));
        }
        if ((Integer)index.getValue() > 0) {
            stepperTag.addStyle((Context)contexts.get(((Integer)index.getValue()).intValue()), "display", "none");
            stepperTag.addStyle((Context)contexts.get((Integer)index.getValue() - 1), "display", "flex");
            index.setValue((Object)((Integer)index.getValue() - 1));
        } else if ((Integer)index.getValue() == 0) {
            index.setValue((Object)-1);
            this.getInstanceNameTag(context).addStyle(context.getParent(), "display", "flex");
            stepperTag.addStyle((Context)contexts.get(0), "display", "none");
        }
    }
}

