/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.extended.ExtendedAnnotationsManager;
import org.genericsystem.reactor.extended.ExtendedRootTag;
import org.genericsystem.reactor.gscomponents.TagImpl;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=InheritStyles.class)
@Process(value=InheritStyleProcessor.class, repeatable=true)
@GenericProcess(value=InheritStyleGenericProcessor.class)
public @interface InheritStyle {
    public Class<? extends TagImpl>[] path() default {};

    public String[] value();

    public int[] pos() default {};

    public static class InheritStyleGenericProcessor
    implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
        @Override
        public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
            gTag.setArrayValueAnnotation(InheritStyle.class, null, ((InheritStyle)annotation).value(), ((InheritStyle)annotation).path(), ((InheritStyle)annotation).pos());
        }

        @Override
        public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            for (String v : annotationContent.getStringArrayContent()) {
                tag.getDomNodeStyles(context).remove((Object)v);
            }
        }

        @Override
        public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            for (String v : annotationContent.getStringArrayContent()) {
                tag.inheritStyle(context, v);
            }
        }
    }

    public static class InheritStyleProcessor
    implements BiConsumer<Annotation, Tag> {
        @Override
        public void accept(Annotation annotation, Tag tag) {
            for (String v : ((InheritStyle)annotation).value()) {
                tag.inheritStyle(v);
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface InheritStyles {
        public InheritStyle[] value();
    }
}

