/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor;

import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableIntegerValue;
import javafx.beans.value.ObservableLongValue;
import javafx.collections.ObservableList;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.common.AbstractCache;
import org.genericsystem.common.Generic;
import org.genericsystem.reactor.HtmlDomNode;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.RootContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    protected static Logger log = LoggerFactory.getLogger(Context.class);
    private Context parent;
    private Map<Tag, TagData> tagDataMap = new LinkedHashMap<Tag, TagData>();
    private final Generic[] generics;
    private boolean destroyed = false;

    public Context(Context parent, Generic[] generics) {
        this.parent = parent;
        this.generics = generics;
    }

    public Context getParent() {
        return this.parent;
    }

    public ObservableList<Context> getSubContexts(Tag tag) {
        return this.tagDataMap.get(tag) != null ? this.tagDataMap.get(tag).getSubContexts() : null;
    }

    public List<Context> getSubContexts() {
        return this.tagDataMap.values().stream().map(tagData -> tagData.getSubContexts()).filter(list -> list != null).flatMap(list -> list.stream()).collect(Collectors.toList());
    }

    public List<ObservableList<Context>> getSubContextsLists() {
        return this.tagDataMap.values().stream().map(tagData -> tagData.getSubContexts()).filter(list -> list != null).collect(Collectors.toList());
    }

    public boolean containsAttribute(Tag tag, String propertyName) {
        return this.tagDataMap.containsKey(tag) ? this.tagDataMap.get(tag).getAttributes().containsKey(propertyName) : false;
    }

    public Map<String, Object> getAttributes(Tag tag) {
        TagData tagData = this.tagDataMap.get(tag);
        if (tagData == null) {
            tagData = new TagData();
            this.tagDataMap.put(tag, tagData);
        }
        return tagData.getAttributes();
    }

    <T> T getAttribute(Tag tag, String propertyName) {
        return (T)this.getAttributes(tag).get(propertyName);
    }

    public void createNewContextProperty(Tag tag, String propertyName) {
        if (this.getAttributes(tag).containsKey(propertyName)) {
            throw new IllegalStateException("Unable to create an already used property : " + propertyName);
        }
        this.getAttributes(tag).put(propertyName, new SimpleObjectProperty());
    }

    protected <T> void setContextPropertyValue(Tag tag, String propertyName, T value) {
        if (!this.containsAttribute(tag, propertyName)) {
            this.createNewContextProperty(tag, propertyName);
        }
        ((Property)this.getAttribute(tag, propertyName)).setValue(value);
    }

    protected <T> void addContextAttribute(Tag tag, String propertyName, T value) {
        if (this.getAttributes(tag).containsKey(propertyName)) {
            throw new IllegalStateException("Unable to store an already used property : " + propertyName);
        }
        this.getAttributes(tag).put(propertyName, value);
    }

    protected <T> void setContextAttribute(Tag tag, String propertyName, T value) {
        this.getAttributes(tag).put(propertyName, value);
    }

    public void removeTag(Tag tag) {
        HtmlDomNode htmlDomNode = this.getHtmlDomNode(tag);
        if (htmlDomNode != null) {
            for (Tag childTag : tag.getObservableChildren()) {
                this.removeTag(childTag);
            }
            htmlDomNode.destroy();
            htmlDomNode.sendRemove();
        }
        if (this.getSubContexts(tag) != null) {
            for (Context subContext : this.getSubContexts(tag)) {
                subContext.destroy();
            }
        }
        this.tagDataMap.remove(tag);
    }

    public void addTag(Tag tag) {
        this.getHtmlDomNode(tag.getParent()).tagAdder.accept(tag);
    }

    void setSubContexts(Tag tag, ObservableList<Context> subContexts) {
        TagData tagData = this.tagDataMap.get(tag);
        assert (tagData == null || tagData.getSubContexts() == null);
        if (tagData == null) {
            tagData = new TagData();
            this.tagDataMap.put(tag, tagData);
        }
        tagData.setSubContexts(subContexts);
    }

    boolean addSubContext(Tag tag, Context subContext) {
        if (this.getSubContexts(tag).contains((Object)subContext)) {
            return false;
        }
        return this.getSubContexts(tag).add((Object)subContext);
    }

    public void register(HtmlDomNode htmlDomNode) {
        TagData domNodeTagData = this.tagDataMap.get(htmlDomNode.getTag());
        assert (domNodeTagData == null || domNodeTagData.getHtmlDomNode() == null);
        if (domNodeTagData == null) {
            domNodeTagData = new TagData();
            this.tagDataMap.put(htmlDomNode.getTag(), domNodeTagData);
        }
        domNodeTagData.setHtmlDomNode(htmlDomNode);
    }

    public void destroy() {
        assert (!this.destroyed) : this;
        this.destroyed = true;
        for (ObservableList<Context> subModels : this.getSubContextsLists()) {
            for (Context subModel : subModels) {
                subModel.destroy();
            }
        }
        List<HtmlDomNode> domNodes = this.getHtmlDomNodes();
        domNodes.forEach(htmlDomNode -> htmlDomNode.destroy());
        if (!domNodes.isEmpty()) {
            domNodes.get(0).sendRemove();
        }
        this.tagDataMap = new LinkedHashMap<Tag, TagData>();
    }

    public HtmlDomNode getHtmlDomNode(Tag tag) {
        return this.tagDataMap.get(tag) != null ? this.tagDataMap.get(tag).getHtmlDomNode() : null;
    }

    public List<HtmlDomNode> getHtmlDomNodes() {
        return this.tagDataMap.values().stream().map(tagData -> tagData.getHtmlDomNode()).filter(htmlDomNode -> htmlDomNode != null).collect(Collectors.toList());
    }

    public Map<Tag, TagData> getTagDataMap() {
        return this.tagDataMap;
    }

    public Generic[] getGenerics() {
        return this.generics;
    }

    public static Generic[] addToGenerics(Generic generic, Generic[] generics) {
        if (generics.length != 0 && generics[0].equals(generic)) {
            return generics;
        }
        Generic[] result = new Generic[generics.length + 1];
        result[0] = generic;
        System.arraycopy(generics, 0, result, 1, generics.length);
        return result;
    }

    public Generic getGeneric() {
        return this.generics[0];
    }

    public void remove() {
        this.getGeneric().remove();
    }

    public Generic find(Class<?> clazz) {
        return this.getGeneric().getRoot().find(clazz);
    }

    public void flush() {
        this.getCache().flush();
    }

    public void cancel() {
        this.getCache().clear();
    }

    public ObservableIntegerValue getCacheLevelObservableValue() {
        return this.getCache().getCacheLevelObservableValue();
    }

    public ObservableLongValue getTsObservableValue() {
        return this.getCache().getTsObservableValue();
    }

    public void mount() {
        this.getCache().mount();
    }

    public void unmount() {
        this.getCache().unmount();
    }

    public BooleanBinding isInCache() {
        return this.getCache().isInCache(this.getGeneric());
    }

    public long shiftTs() throws RollbackException {
        return this.getCache().shiftTs();
    }

    public boolean isDestroyed() {
        return this.destroyed;
    }

    public RootContext getRootContext() {
        return this.getParent().getRootContext();
    }

    public AbstractCache getCache() {
        return this.getParent().getCache();
    }

    public int hashCode() {
        return Arrays.hashCode(this.generics);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Context)) {
            return false;
        }
        Context other = (Context)obj;
        return Arrays.equals(this.generics, other.generics) && Objects.equals(this.parent, other.parent);
    }

    private static class TagData {
        private HtmlDomNode htmlDomNode;
        private ObservableList<Context> subContexts;
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        private TagData() {
        }

        public HtmlDomNode getHtmlDomNode() {
            return this.htmlDomNode;
        }

        public ObservableList<Context> getSubContexts() {
            return this.subContexts;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public void setHtmlDomNode(HtmlDomNode htmlDomNode) {
            this.htmlDomNode = htmlDomNode;
        }

        public void setSubContexts(ObservableList<Context> subContexts) {
            this.subContexts = subContexts;
        }
    }
}

