/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.appserver;

import io.vertx.core.json.JsonObject;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.genericsystem.common.EnginesDeploymentConfig;
import org.genericsystem.common.Root;
import org.genericsystem.kernel.Engine;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.RootTag;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.DependsOnModel;
import org.genericsystem.reactor.context.RootContext;
import org.genericsystem.reactor.gscomponents.RootTagImpl;

public class WebAppsConfig
extends JsonObject {
    public WebAppsConfig() {
        this(8080);
    }

    public WebAppsConfig(String[] mainArgs) {
        this(mainArgs.length != 0 ? Integer.parseInt(mainArgs[0]) : 8080);
    }

    public WebAppsConfig(int port) {
        this.put("apps", new JsonObject());
        this.put("host", "0.0.0.0");
        this.put("port", port);
    }

    public String getHost() {
        return this.getString("host");
    }

    public int getPort() {
        return this.getInteger("port");
    }

    public Set<String> getApplicationsPaths() {
        return this.getJsonObject("apps").getMap().keySet();
    }

    public Class<? extends RootTag> getApplicationClass(String applicationPath) {
        return this.getApplicationDeploymentConfig(applicationPath).getApplicationClass();
    }

    public Class<Context> getModelClass(String applicationPath) {
        return this.getApplicationDeploymentConfig(applicationPath).getModelClass();
    }

    private ApplicationDeploymentConfig getApplicationDeploymentConfig(String applicationPath) {
        return this.applicationDeploymentConfig(this.getJsonObject("apps").getJsonObject(applicationPath));
    }

    private ApplicationDeploymentConfig applicationDeploymentConfig(JsonObject json) {
        return new ApplicationDeploymentConfig(json.getMap());
    }

    public static Class<?>[] getModelClasses(Class<?> applicationClass) {
        DependsOnModel dependOn = applicationClass.getAnnotation(DependsOnModel.class);
        return dependOn != null ? dependOn.value() : new Class[]{};
    }

    public WebAppsConfig addApplication(String path, Class<? extends Tag> htmlAppClass, Class<? extends Context> modelClass, Class<? extends Root> engineClass, String persistentDirectoryPath) {
        this.getJsonObject("apps").put(path, (JsonObject)new ApplicationDeploymentConfig(htmlAppClass, modelClass, engineClass, persistentDirectoryPath, WebAppsConfig.getModelClasses(htmlAppClass)));
        return this;
    }

    public void removeApplication(String path) {
        this.getJsonObject("apps").remove(path);
    }

    public Set<Class<?>> getClasses(String persistentDirectoryPath) {
        return this.getJsonObject("apps").getMap().values().stream().map(json -> this.applicationDeploymentConfig((JsonObject)json)).filter(conf -> Objects.equals(persistentDirectoryPath, conf.getPersistentDirectoryPath())).flatMap(conf -> conf.getClasses().stream()).collect(Collectors.toSet());
    }

    public Class<? extends Root> getEngineClass(String persistentDirectoryPath) {
        Set set = this.getJsonObject("apps").getMap().values().stream().map(json -> this.applicationDeploymentConfig((JsonObject)json)).filter(conf -> Objects.equals(persistentDirectoryPath, conf.getPersistentDirectoryPath())).map(conf -> conf.getEngineClass()).collect(Collectors.toSet());
        assert (set.size() == 1);
        return (Class)set.iterator().next();
    }

    public Set<String> getPersistentDirectoryPaths() {
        return this.getJsonObject("apps").getMap().keySet().stream().map(this::getPersistentDirectoryPath).collect(Collectors.toSet());
    }

    public String getPersistentDirectoryPath(String applicationPath) {
        return this.getApplicationDeploymentConfig(applicationPath).getPersistentDirectoryPath();
    }

    public String getRootId() {
        return "root";
    }

    public static class SimpleWebAppConfig
    extends WebAppsConfig {
        public SimpleWebAppConfig(String[] mainArgs, Class<? extends RootTagImpl> htmlAppClass, String homePersistentDirectoryPath) {
            super(mainArgs);
            this.addApplication("/", htmlAppClass, RootContext.class, Engine.class, System.getenv("HOME") + "/genericsystem/" + homePersistentDirectoryPath);
        }
    }

    public static class ApplicationDeploymentConfig
    extends EnginesDeploymentConfig.EngineDeploymentConfig {
        public ApplicationDeploymentConfig(Map<String, Object> map) {
            super(map);
            assert (this.getString("applicationClass") != null);
        }

        public ApplicationDeploymentConfig(Class<? extends Tag> applicationClass, Class<? extends Context> modelClass, Class<? extends Root> engineClass, String repositoryPath, Class<?> ... classes) {
            super(repositoryPath, (Class[])classes);
            this.put("applicationClass", applicationClass.getName());
            this.put("modelClass", modelClass.getName());
            this.put("engineClass", engineClass.getName());
        }

        public Class<? extends RootTag> getApplicationClass() {
            try {
                return Class.forName(this.getString("applicationClass"));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public Class<? extends Root> getEngineClass() {
            try {
                return Class.forName(this.getString("engineClass"));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }

        public Class<Context> getModelClass() {
            try {
                return Class.forName(this.getString("modelClass"));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e);
            }
        }
    }
}

