/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.genericsystem.api.core.TagAnnotation;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.contextproperties.FlexDirectionDefaults;
import org.genericsystem.reactor.extended.ExtendedAnnotationsManager;
import org.genericsystem.reactor.extended.ExtendedRootTag;
import org.genericsystem.reactor.gscomponents.FlexDirection;
import org.genericsystem.reactor.gscomponents.TagImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=Styles.class)
@Process(value=StyleProcessor.class, repeatable=true)
@GenericProcess(value=StyleGenericProcessor.class)
public @interface Style {
    public Class<? extends TagImpl>[] path() default {};

    public String name();

    public String value();

    public int[] pos() default {};

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Repeatable(value=GenericValueBackgroundColors.class)
    @Process(value=GenericValueBackgroundColorProcessor.class)
    @GenericProcess(value=GenericValueBackgroundColorGenericProcessor.class)
    public static @interface GenericValueBackgroundColor {
        public Class<? extends TagImpl>[] path() default {};

        public String value();

        public int[] pos() default {};

        public static class GenericValueBackgroundColorGenericProcessor
        implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
            @Override
            public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
                GenericValueBackgroundColor annotation_ = (GenericValueBackgroundColor)annotation;
                gTag.setAnnotation(GenericValueBackgroundColor.class, null, annotation_.value(), annotation_.path(), annotation_.pos());
            }

            @Override
            public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
                tag.getDomNodeStyles(context).remove((Object)"background-color");
            }

            @Override
            public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
                tag.getRootTag().processGenericValueBackgroundColor(tag, context, annotationContent.getContentValue());
            }
        }

        public static class GenericValueBackgroundColorProcessor
        implements BiConsumer<Annotation, Tag> {
            @Override
            public void accept(Annotation annotation, Tag tag) {
                tag.getRootTag().processGenericValueBackgroundColor(tag, ((GenericValueBackgroundColor)annotation).value());
            }
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface GenericValueBackgroundColors {
            public GenericValueBackgroundColor[] value();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Repeatable(value=ReverseFlexDirections.class)
    @Process(value=ReverseFlexDirectionProcessor.class)
    @GenericProcess(value=ReverseFlexDirectionGenericProcessor.class)
    public static @interface ReverseFlexDirection {
        public Class<? extends TagImpl>[] path() default {};

        public int[] pos() default {};

        public static class ReverseFlexDirectionGenericProcessor
        implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
            @Override
            public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
                ReverseFlexDirection annotation_ = (ReverseFlexDirection)annotation;
                gTag.setAnnotation(ReverseFlexDirection.class, null, null, annotation_.path(), annotation_.pos());
            }

            @Override
            public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
                ((FlexDirectionDefaults)((Object)tag)).stopTrackingDirection(context);
            }

            @Override
            public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
                tag.getRootTag().processReverseFlexDirection(tag, context);
            }
        }

        public static class ReverseFlexDirectionProcessor
        implements BiConsumer<Annotation, Tag> {
            @Override
            public void accept(Annotation annotation, Tag tag) {
                tag.getRootTag().processReverseFlexDirection(tag);
            }
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface ReverseFlexDirections {
            public ReverseFlexDirection[] value();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Repeatable(value=KeepFlexDirections.class)
    @Process(value=KeepFlexDirectionProcessor.class)
    @GenericProcess(value=KeepFlexDirectionGenericProcessor.class)
    public static @interface KeepFlexDirection {
        public Class<? extends TagImpl>[] path() default {};

        public int[] pos() default {};

        public static class KeepFlexDirectionGenericProcessor
        extends ReverseFlexDirection.ReverseFlexDirectionGenericProcessor {
            @Override
            public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
                KeepFlexDirection annotation_ = (KeepFlexDirection)annotation;
                gTag.setAnnotation(KeepFlexDirection.class, null, null, annotation_.path(), annotation_.pos());
            }

            @Override
            public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
                tag.getRootTag().processKeepFlexDirection(tag, context);
            }
        }

        public static class KeepFlexDirectionProcessor
        implements BiConsumer<Annotation, Tag> {
            @Override
            public void accept(Annotation annotation, Tag tag) {
                tag.getRootTag().processKeepFlexDirection(tag);
            }
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface KeepFlexDirections {
            public KeepFlexDirection[] value();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Repeatable(value=FlexDirections.class)
    @Process(value=FlexDirectionStyleProcessor.class)
    @GenericProcess(value=FlexDirectionStyleGenericProcessor.class)
    public static @interface FlexDirectionStyle {
        public Class<? extends TagImpl>[] path() default {};

        public FlexDirection value();

        public int[] pos() default {};

        public static class FlexDirectionStyleGenericProcessor
        implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
            public static final Logger log = LoggerFactory.getLogger(FlexDirectionStyleGenericProcessor.class);

            @Override
            public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
                FlexDirectionStyle annotation_ = (FlexDirectionStyle)annotation;
                ExtendedRootTag.GTagAnnotation gTagAnnotation = (ExtendedRootTag.GTagAnnotation)gTag.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationAttribute.class), (Serializable)new TagAnnotation(FlexDirectionStyle.class, (Class[])annotation_.path(), annotation_.pos()), (DefaultGeneric[])new Generic[0]);
                gTagAnnotation.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationContentAttribute.class), (Serializable)((Object)new JsonObject().put("value", (Enum)annotation_.value()).encodePrettily()), (DefaultGeneric[])new Generic[0]);
            }

            @Override
            public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
                if (FlexDirectionDefaults.class.isAssignableFrom(tag.getClass())) {
                    ((FlexDirectionDefaults)((Object)tag)).setDirection(context, null);
                } else {
                    log.warn("Warning: FlexDirection is applicable only to classes implementing FlexDirectionDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
                }
            }

            @Override
            public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
                tag.getRootTag().processFlexDirectionStyle(tag, context, FlexDirection.valueOf(annotationContent.getContentValue()));
            }
        }

        public static class FlexDirectionStyleProcessor
        implements BiConsumer<Annotation, Tag> {
            @Override
            public void accept(Annotation annotation, Tag tag) {
                tag.getRootTag().processFlexDirectionStyle(tag, ((FlexDirectionStyle)annotation).value());
            }
        }

        @Retention(value=RetentionPolicy.RUNTIME)
        @Target(value={ElementType.TYPE})
        public static @interface FlexDirections {
            public FlexDirectionStyle[] value();
        }
    }

    public static class StyleGenericProcessor
    implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
        @Override
        public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
            Style annotation_ = (Style)annotation;
            gTag.setAnnotation(Style.class, annotation_.name(), annotation_.value(), annotation_.path(), annotation_.pos());
        }

        @Override
        public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.getDomNodeStyles(context).remove((Object)gTagAnnotation.getValue().getName());
        }

        @Override
        public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.getRootTag().processStyle(tag, context, gTagAnnotation.getValue().getName(), annotationContent.getContentValue());
        }
    }

    public static class StyleProcessor
    implements BiConsumer<Annotation, Tag> {
        @Override
        public void accept(Annotation annotation, Tag tag) {
            tag.getRootTag().processStyle(tag, ((Style)annotation).name(), ((Style)annotation).value());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Styles {
        public Style[] value();
    }
}

