/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.contextproperties;

import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WeakChangeListener;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.tools.BidirectionalBinding;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.StringExtractor;
import org.genericsystem.reactor.contextproperties.ContextProperty;

public interface SelectionDefaults
extends ContextProperty {
    public static final String SELECTION = "selection";
    public static final String UPDATED_GENERIC = "updatedGeneric";
    public static final String SELECTION_INDEX = "selectionIndex";
    public static final String SELECTION_SHIFT = "selectionShift";
    public static final String SELECTION_STRING = "selectionString";
    public static final String CONTEXTS_LISTENER = "contextsListener";
    public static final String UPDATED_GENERIC_LISTENER = "updatedGenericListener";

    default public void createSelectionProperty() {
        this.createNewContextProperty(SELECTION);
        this.addContextAttribute(SELECTION_STRING, model -> Bindings.createStringBinding(() -> (String)StringExtractor.SIMPLE_CLASS_EXTRACTOR.apply(this.getSelectionProperty((Context)model).getValue() != null ? ((Context)this.getSelectionProperty((Context)model).getValue()).getGeneric() : null), (Observable[])new Observable[]{this.getSelectionProperty((Context)model)}));
        this.addContextAttribute(SELECTION_INDEX, model -> {
            SimpleObjectProperty index = new SimpleObjectProperty();
            index.addListener((ChangeListener)new WeakChangeListener(model.getHtmlDomNode((Tag)this).getIndexListener()));
            return index;
        });
        this.createNewContextProperty(UPDATED_GENERIC);
    }

    default public Property<Context> getSelectionProperty(Context context) {
        return this.getContextProperty(SELECTION, context);
    }

    default public Property<Generic> getUpdatedGenericProperty(Context context) {
        return this.getContextProperty(UPDATED_GENERIC, context);
    }

    default public Property<Integer> getSelectionIndex(Context context) {
        return this.getContextProperty(SELECTION_INDEX, context);
    }

    default public void setSelectionShift(int shift) {
        this.createNewInitializedProperty(SELECTION_SHIFT, context -> shift);
    }

    default public int getSelectionShift(Context context) {
        Property selectionShiftProperty = this.getContextProperty(SELECTION_SHIFT, context);
        return selectionShiftProperty != null ? (Integer)selectionShiftProperty.getValue() : 0;
    }

    default public ObservableValue<String> getSelectionString(Context context) {
        return this.getContextObservableValue(SELECTION_STRING, context);
    }

    default public ListChangeListener<Context> getContextsListenerProperty(Context context) {
        return (ListChangeListener)this.getContextAttribute(CONTEXTS_LISTENER, context);
    }

    default public ChangeListener<Generic> getUpdatedGenericListenerProperty(Context context) {
        return (ChangeListener)this.getContextAttribute(UPDATED_GENERIC_LISTENER, context);
    }

    default public void bindBiDirectionalSelection(Tag subElement) {
        this.addPostfixBinding(modelContext -> {
            ObservableList<Context> subContexts = modelContext.getSubContexts(subElement);
            Generic selectedGeneric = modelContext.getGeneric();
            Optional<Context> selectedModel = subContexts.stream().filter(sub -> selectedGeneric.equals(sub.getGeneric())).findFirst();
            Property<Context> selection = this.getSelectionProperty((Context)modelContext);
            int selectionShift = this.getSelectionShift((Context)modelContext);
            selection.setValue(selectedModel.isPresent() ? selectedModel.get() : null);
            Property<Integer> selectionIndex = this.getSelectionIndex((Context)modelContext);
            BidirectionalBinding.bind(selectionIndex, selection, number -> number - selectionShift >= 0 ? (Context)subContexts.get(number - selectionShift) : null, genericModel -> subContexts.indexOf(genericModel) + selectionShift);
            subContexts.addListener(change -> {
                Integer newIndex;
                if (selection != null && (newIndex = Integer.valueOf(subContexts.indexOf(selection.getValue()) + selectionShift)) != selectionIndex.getValue()) {
                    selectionIndex.setValue((Object)newIndex);
                }
            });
        });
    }

    default public void bindSelection(Tag subElement, Context context) {
        ObservableList<Context> subContexts = context.getSubContexts(subElement);
        Property<Context> selection = this.getSelectionProperty(context);
        Property<Generic> updatedGeneric = this.getUpdatedGenericProperty(context);
        this.setContextAttribute(CONTEXTS_LISTENER, context, change -> {
            if (selection.getValue() != null) {
                while (change.next()) {
                    if (!change.wasRemoved() || change.wasAdded() || !change.getRemoved().stream().map(c -> c.getGeneric()).collect(Collectors.toList()).contains(((Context)selection.getValue()).getGeneric())) continue;
                    selection.setValue(null);
                }
            }
        });
        this.setContextAttribute(UPDATED_GENERIC_LISTENER, context, (o, v, nv) -> {
            Optional<Context> updatedContext = subContexts.stream().filter(m -> m.getGeneric().equals(nv)).findFirst();
            if (updatedContext.isPresent() && selection.getValue() == null) {
                selection.setValue((Object)updatedContext.get());
            }
        });
        if (selection != null && updatedGeneric != null) {
            subContexts.addListener(this.getContextsListenerProperty(context));
            updatedGeneric.addListener(this.getUpdatedGenericListenerProperty(context));
        }
    }

    default public void unbindSelection(Tag subElement, Context context) {
        ObservableList<Context> subContexts = context.getSubContexts(subElement);
        Property<Context> selection = this.getSelectionProperty(context);
        Property<Generic> updatedGeneric = this.getUpdatedGenericProperty(context);
        if (selection != null && updatedGeneric != null) {
            subContexts.removeListener(this.getContextsListenerProperty(context));
            updatedGeneric.removeListener(this.getUpdatedGenericListenerProperty(context));
        }
    }
}

