/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.context;

import io.reactivex.Observable;
import java.util.Optional;
import java.util.function.BiFunction;
import org.genericsystem.defaults.tools.RxJavaHelpers;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.ForEachExtractor;
import org.genericsystem.reactor.contextproperties.SelectionDefaults;

public interface OptionalContextSelector
extends BiFunction<Context, Tag, Observable<Optional<Context>>> {

    public static class HOLDER_ADDITION_ENABLED_SELECTOR
    implements OptionalContextSelector {
        @Override
        public Observable<Optional<Context>> apply(Context context, Tag tag) {
            return ((Observable)ForEachExtractor.HOLDERS.apply(context.getGenerics())).switchMap(s -> s.setOnChanged()).map(holders -> holders.isEmpty() || (context.getGeneric().getComponents().size() != 1 || !context.getGeneric().isPropertyConstraintEnabled()) && !context.getGeneric().isSingularConstraintEnabled(context.getGeneric().getComponents().indexOf(context.getGenerics()[2])) ? Optional.of(context) : Optional.empty());
        }
    }

    public static class REMOVABLE_HOLDER_SELECTOR
    implements OptionalContextSelector {
        @Override
        public Observable<Optional<Context>> apply(Context context, Tag tag) {
            return ((Observable)ForEachExtractor.HOLDERS.apply(context.getParent().getGenerics())).switchMap(s -> s.setOnChanged()).map(holders -> !context.getParent().getGeneric().isRequiredConstraintEnabled(context.getGeneric().getComponents().indexOf(context.getGenerics()[2])) && holders.size() == 1 || holders.size() > 1 ? Optional.of(context) : Optional.empty());
        }
    }

    public static class SELECTION_SELECTOR
    implements OptionalContextSelector {
        @Override
        public Observable<Optional<Context>> apply(Context context, Tag tag) {
            if (SelectionDefaults.class.isAssignableFrom(tag.getClass())) {
                return RxJavaHelpers.optionalValuesOf(tag.getSelectionProperty(context));
            }
            throw new IllegalStateException("SELECTION_SELECTOR is applicable only to tags implementing SelectionDefaults.");
        }
    }
}

