/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.gscomponents;

import java.io.Serializable;
import java.util.Arrays;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.EncryptionUtils;
import org.genericsystem.reactor.annotations.Attribute;
import org.genericsystem.reactor.annotations.BindAction;
import org.genericsystem.reactor.annotations.BindText;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.annotations.SetText;
import org.genericsystem.reactor.annotations.Style;
import org.genericsystem.reactor.annotations.Switch;
import org.genericsystem.reactor.context.ContextAction;
import org.genericsystem.reactor.context.TagSwitcher;
import org.genericsystem.reactor.context.TextBinding;
import org.genericsystem.reactor.contextproperties.PasswordDefaults;
import org.genericsystem.reactor.contextproperties.UserRoleDefaults;
import org.genericsystem.reactor.gscomponents.FlexDirection;
import org.genericsystem.reactor.gscomponents.FlexDiv;
import org.genericsystem.reactor.gscomponents.HtmlTag;
import org.genericsystem.reactor.gscomponents.InstancesTable;
import org.genericsystem.reactor.gscomponents.Modal;
import org.genericsystem.security.model.User;

@Children(value={HtmlTag.HtmlButton.class, HtmlTag.HtmlLabel.class, HtmlTag.HtmlButton.class})
@Switch(path={HtmlTag.HtmlButton.class}, value={TagSwitcher.ADMIN_MODE_ONLY.class})
@SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlButton.class}, pos={0}, value={"Save"}), @SetText(path={HtmlTag.HtmlButton.class}, pos={1}, value={"Cancel"})})
@BindAction.BindActions(value={@BindAction(path={HtmlTag.HtmlButton.class}, pos={0}, value={ContextAction.FLUSH.class}), @BindAction(path={HtmlTag.HtmlButton.class}, pos={1}, value={ContextAction.CANCEL.class})})
@BindText(path={HtmlTag.HtmlLabel.class}, pos={0}, value=TextBinding.LAST_UPDATE.class)
@Style.FlexDirectionStyle(value=FlexDirection.ROW)
@Style.Styles(value={@Style(name="justify-content", value="space-around"), @Style(name="padding", value="10px")})
public class Monitor
extends FlexDiv {

    @Children(value={HtmlTag.HtmlButton.class, HtmlTag.HtmlButton.class, HtmlTag.HtmlLabel.class, LoginDiv.class, LoggedUserDiv.class})
    public static class MonitorLogin
    extends Monitor
    implements UserRoleDefaults {

        @Children.ChildrenMult(value={@Children(value={HtmlTag.HtmlLabel.class, HtmlTag.HtmlInputText.class, HtmlTag.HtmlSpan.class, HtmlTag.HtmlLabel.class, HtmlTag.HtmlInputText.class, HtmlTag.HtmlLabel.class, HtmlTag.HtmlInputText.class, HtmlTag.HtmlSpan.class, InstancesTable.ButtonDiv.class}), @Children(path={InstancesTable.ButtonDiv.class}, value={HtmlTag.HtmlButton.class, HtmlTag.HtmlButton.class})})
        @Style.Styles(value={@Style(path={InstancesTable.ButtonDiv.class}, name="flex", value="1"), @Style(path={HtmlTag.HtmlSpan.class}, name="display", value="none")})
        @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlLabel.class}, pos={0}, value={"Username :"}), @SetText(path={HtmlTag.HtmlLabel.class}, pos={1}, value={"Password :"}), @SetText(path={HtmlTag.HtmlLabel.class}, pos={2}, value={"Confirm password:"}), @SetText(path={InstancesTable.ButtonDiv.class, HtmlTag.HtmlButton.class}, pos={0, 0}, value={"OK"}), @SetText(path={InstancesTable.ButtonDiv.class, HtmlTag.HtmlButton.class}, pos={0, 1}, value={"Cancel"}), @SetText(path={HtmlTag.HtmlSpan.class}, pos={0}, value={"Username already exists."}), @SetText(path={HtmlTag.HtmlSpan.class}, pos={1}, value={"These passwords don\u2019t match. Try again."})})
        @Attribute.Attributes(value={@Attribute(path={HtmlTag.HtmlInputText.class}, pos={1}, name="type", value="password"), @Attribute(path={HtmlTag.HtmlInputText.class}, pos={2}, name="type", value="password")})
        @BindAction.BindActions(value={@BindAction(path={InstancesTable.ButtonDiv.class, HtmlTag.HtmlButton.class}, pos={0, 0}, value={ContextAction.CREATE_USER.class}), @BindAction(path={InstancesTable.ButtonDiv.class, HtmlTag.HtmlButton.class}, pos={0, 1}, value={ContextAction.DISPLAY_NONE_CANCEL.class})})
        public static class UserCreation
        extends FlexDiv {
        }

        @Switch(value={TagSwitcher.NO_LOGGED_USER.class})
        @Children.ChildrenMult(value={@Children(value={HtmlTag.HtmlLabel.class, HtmlTag.HtmlInputText.class, HtmlTag.HtmlLabel.class, HtmlTag.HtmlInputText.class, ValidateButton.class, HtmlTag.HtmlSpan.class, HtmlTag.HtmlSpan.class, Modal.ModalWithDisplay.class, HtmlTag.HtmlHyperLink.class}), @Children(path={Modal.ModalWithDisplay.class, FlexDiv.class}, value={UserCreation.class})})
        @Style.FlexDirectionStyle(value=FlexDirection.ROW)
        @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlLabel.class}, pos={0}, value={"Login: "}), @SetText(path={HtmlTag.HtmlLabel.class}, pos={1}, value={"Password: "}), @SetText(path={HtmlTag.HtmlSpan.class}, pos={0}, value={"Invalid username."}), @SetText(path={HtmlTag.HtmlSpan.class}, pos={1}, value={"Invalid password."}), @SetText(path={HtmlTag.HtmlHyperLink.class}, value={"Sign up"})})
        @Style(path={HtmlTag.HtmlSpan.class}, name="display", value="none")
        @Attribute(path={HtmlTag.HtmlInputText.class}, pos={1}, name="type", value="password")
        @BindAction(path={HtmlTag.HtmlHyperLink.class}, value={ContextAction.MODAL_DISPLAY_FLEX.class})
        public static class LoginDiv
        extends FlexDiv
        implements UserRoleDefaults {

            @SetText(value={"OK"})
            public static class ValidateButton
            extends HtmlTag.HtmlButton
            implements PasswordDefaults,
            UserRoleDefaults {
                @Override
                public void init() {
                    this.createSaltProperty();
                    this.bindAction(context -> {
                        HtmlTag.HtmlInputText loginInput = this.getParent().find(HtmlTag.HtmlInputText.class);
                        HtmlTag.HtmlInputText passwordInput = this.getParent().find(HtmlTag.HtmlInputText.class, 1);
                        HtmlTag.HtmlSpan invalidLogin = this.getParent().find(HtmlTag.HtmlSpan.class);
                        HtmlTag.HtmlSpan invalidPassword = this.getParent().find(HtmlTag.HtmlSpan.class, 1);
                        Generic user = (Generic)context.find(User.class).getInstance((Serializable)loginInput.getDomNodeAttributes((Context)context).get((Object)"value"), (DefaultGeneric[])new Generic[0]);
                        if (user != null) {
                            Generic hashGeneric = (Generic)context.find(User.Password.class).getInstance((DefaultGeneric[])new Generic[]{user});
                            byte[] salt = (byte[])((Generic)context.find(User.Salt.class).getInstance((DefaultGeneric[])new Generic[]{hashGeneric})).getValue();
                            if (Arrays.equals((byte[])hashGeneric.getValue(), EncryptionUtils.getEncryptedPassword((String)passwordInput.getDomNodeAttributes((Context)context).get((Object)"value"), salt))) {
                                loginInput.getDomNodeAttributes((Context)context).put((Object)"value", (Object)"");
                                passwordInput.getDomNodeAttributes((Context)context).put((Object)"value", (Object)"");
                                invalidLogin.addStyle((Context)context, "display", "none");
                                invalidPassword.addStyle((Context)context, "display", "none");
                                this.getLoggedUserProperty((Context)context).setValue((Object)user);
                            } else {
                                invalidLogin.addStyle((Context)context, "display", "none");
                                invalidPassword.addStyle((Context)context, "display", "inline");
                            }
                        } else {
                            invalidLogin.addStyle((Context)context, "display", "inline");
                        }
                    });
                }
            }
        }

        @Switch(value={TagSwitcher.LOGGED_USER.class})
        @Children(value={ModeSwitchButtons.class, HtmlTag.HtmlLabel.class, HtmlTag.HtmlButton.class})
        @Style.FlexDirectionStyle(value=FlexDirection.ROW)
        @SetText(path={HtmlTag.HtmlButton.class}, value={"Disconnect"})
        @BindText(path={HtmlTag.HtmlLabel.class}, value=TextBinding.LOGGED_USER.class)
        @BindAction(path={HtmlTag.HtmlButton.class}, value={ContextAction.DISCONNECT.class})
        public static class LoggedUserDiv
        extends FlexDiv
        implements UserRoleDefaults {

            @Children(value={HtmlTag.HtmlButton.class, HtmlTag.HtmlButton.class})
            @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlButton.class}, pos={0}, value={"Admin mode"}), @SetText(path={HtmlTag.HtmlButton.class}, pos={1}, value={"User mode"})})
            @Switch.Modes(value={@Switch(value={TagSwitcher.LOGGED_USER_ADMIN.class}), @Switch(path={HtmlTag.HtmlButton.class}, pos={0}, value={TagSwitcher.NORMAL_MODE_ONLY.class}), @Switch(path={HtmlTag.HtmlButton.class}, pos={1}, value={TagSwitcher.ADMIN_MODE_ONLY.class}), @Switch(path={HtmlTag.HtmlButton.class}, pos={3}, value={TagSwitcher.ADMIN_MODE_ONLY.class})})
            @BindAction.BindActions(value={@BindAction(path={HtmlTag.HtmlButton.class}, pos={0}, value={ContextAction.SET_ADMIN_MODE.class}), @BindAction(path={HtmlTag.HtmlButton.class}, pos={1}, value={ContextAction.SET_NORMAL_MODE.class})})
            public static class ModeSwitchButtons
            extends FlexDiv {
            }
        }
    }

    @Children(value={HtmlTag.HtmlButton.class, HtmlTag.HtmlButton.class, HtmlTag.HtmlButton.class, HtmlTag.HtmlLabel.class, HtmlTag.HtmlButton.class, HtmlTag.HtmlButton.class, HtmlTag.HtmlLabel.class, HtmlTag.HtmlButton.class})
    @SetText.SetTexts(value={@SetText(path={HtmlTag.HtmlButton.class}, pos={2}, value={"Mount"}), @SetText(path={HtmlTag.HtmlButton.class}, pos={3}, value={"Unmount"}), @SetText(path={HtmlTag.HtmlButton.class}, pos={4}, value={"ShiftTs"}), @SetText(path={HtmlTag.HtmlButton.class}, pos={5}, value={"Collect"}), @SetText(path={HtmlTag.HtmlButton.class}, pos={6}, value={"Flash"})})
    @BindAction.BindActions(value={@BindAction(path={HtmlTag.HtmlButton.class}, pos={2}, value={ContextAction.MOUNT.class}), @BindAction(path={HtmlTag.HtmlButton.class}, pos={3}, value={ContextAction.UNMOUNT.class}), @BindAction(path={HtmlTag.HtmlButton.class}, pos={4}, value={ContextAction.SHIFTTS.class}), @BindAction(path={HtmlTag.HtmlButton.class}, pos={5}, value={ContextAction.GC.class}), @BindAction(path={HtmlTag.HtmlButton.class}, pos={6}, value={ContextAction.FLASH.class})})
    @BindText(path={HtmlTag.HtmlLabel.class}, pos={1}, value=TextBinding.CACHE_LEVEL.class)
    public static class MonitorExtended
    extends Monitor {
    }
}

