/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.gscomponents;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.HtmlDomNode;
import org.genericsystem.reactor.MetaBinding;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.TagNode;
import org.genericsystem.reactor.context.TagSwitcher;

public abstract class TagImpl
implements Tag {
    private final Property<String> tagName = new SimpleStringProperty();
    private final Property<Class<? extends HtmlDomNode>> domNodeClass = new SimpleObjectProperty();
    private Property<MetaBinding<?>> metaBinding = new SimpleObjectProperty();
    private final List<Consumer<Context>> preFixedBindings = new ArrayList<Consumer<Context>>();
    private final List<Consumer<Context>> postFixedBindings = new ArrayList<Consumer<Context>>();
    protected ObservableList<TagSwitcher> switchers = FXCollections.observableArrayList();
    protected TagNode tagNode;
    private Tag parent;

    @Override
    public TagNode getTagNode() {
        return this.tagNode;
    }

    @Override
    public void setTagNode(TagNode tagNode) {
        this.tagNode = tagNode;
    }

    @Override
    public String getTag() {
        return (String)this.tagName.getValue();
    }

    @Override
    public void setTag(String tagName) {
        this.tagName.setValue((Object)tagName);
    }

    @Override
    public Class<? extends HtmlDomNode> getDomNodeClass() {
        return this.domNodeClass.getValue() != null ? (Class)this.domNodeClass.getValue() : HtmlDomNode.class;
    }

    @Override
    public void setDomNodeClass(Class<? extends HtmlDomNode> domNodeClass) {
        this.domNodeClass.setValue(domNodeClass);
    }

    @Override
    public void setParent(Tag parent) {
        this.parent = parent;
    }

    @Override
    public ObservableList<Tag> getObservableChildren() {
        return this.getTagNode().getObservableChildren();
    }

    @Override
    public <COMPONENT extends Tag> COMPONENT getParent() {
        return (COMPONENT)this.parent;
    }

    public String toString() {
        return this.getTag() + " " + this.getClass().getName();
    }

    @Override
    public List<Consumer<Context>> getPreFixedBindings() {
        return this.preFixedBindings;
    }

    @Override
    public List<Consumer<Context>> getPostFixedBindings() {
        return this.postFixedBindings;
    }

    @Override
    public <BETWEEN> MetaBinding<BETWEEN> getMetaBinding() {
        return (MetaBinding)this.metaBinding.getValue();
    }

    public Property<MetaBinding<?>> getMetaBindingProperty() {
        return this.metaBinding;
    }

    @Override
    public <BETWEEN> void setMetaBinding(MetaBinding<BETWEEN> metaBinding) {
        this.metaBinding.setValue(metaBinding);
    }

    @Override
    public void addSwitcher(TagSwitcher switcher) {
        this.switchers.add((Object)switcher);
    }

    @Override
    public ObservableList<TagSwitcher> getObservableSwitchers() {
        return this.switchers;
    }
}

