/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.context;

import java.io.Serializable;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import org.genericsystem.api.core.exceptions.RollbackException;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.EncryptionUtils;
import org.genericsystem.reactor.RootHtmlDomNode;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.RootContext;
import org.genericsystem.reactor.contextproperties.ConvertedValueDefaults;
import org.genericsystem.reactor.contextproperties.GSBuilderDefaults;
import org.genericsystem.reactor.contextproperties.PasswordDefaults;
import org.genericsystem.reactor.contextproperties.SelectionDefaults;
import org.genericsystem.reactor.contextproperties.StepperDefaults;
import org.genericsystem.reactor.gscomponents.Composite;
import org.genericsystem.reactor.gscomponents.HtmlTag;
import org.genericsystem.reactor.gscomponents.Modal;
import org.genericsystem.reactor.gscomponents.instancebuilder.InstanceBuilder;
import org.genericsystem.security.model.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ContextAction
extends BiConsumer<Context, Tag> {
    public static final Logger log = LoggerFactory.getLogger(ContextAction.class);

    public static class DISCONNECT
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            tag.getLoggedUserProperty(context).setValue(null);
            tag.getAdminModeProperty(context).setValue((Object)false);
            if (SelectionDefaults.class.isAssignableFrom(tag.getClass())) {
                tag.getSelectionProperty(context).setValue(null);
            }
        }
    }

    public static class SET_NORMAL_MODE
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            tag.getAdminModeProperty(context).setValue((Object)false);
        }
    }

    public static class SET_ADMIN_MODE
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            tag.getAdminModeProperty(context).setValue((Object)true);
        }
    }

    public static class NEXT
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            if (StepperDefaults.class.isAssignableFrom(tag.getClass())) {
                tag.next(context);
            } else {
                log.warn("The NEXT action is applicable only to a tag implementing SwitchDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
            }
        }
    }

    public static class PREVIOUS
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            if (StepperDefaults.class.isAssignableFrom(tag.getClass())) {
                tag.prev(context);
            } else {
                log.warn("The PREVIOUS action is applicable only to a tag implementing StepperDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
            }
        }
    }

    public static class CREATE_INSTANCE
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            if (GSBuilderDefaults.class.isAssignableFrom(tag.getClass())) {
                Tag buildTag = tag;
                Generic type = context.getGeneric();
                Map<Generic, GSBuilderDefaults.GenericValueComponents> gvc = buildTag.getGenericValueComponentsMap(context);
                Generic[] components = (Generic[])gvc.get(type).getComponents().entrySet().stream().filter(obs -> obs.getValue() != null && ((Property)obs.getValue()).getValue() != null).map(entry -> this.getOrSetInstance((Generic)entry.getKey(), (Serializable)((Property)entry.getValue()).getValue())).filter(gen -> gen != null).toArray(Generic[]::new);
                if ((gvc.get(type).getGenericValue().getValue() != null || type.getInstanceValueGenerator() != null || components.length != 0) && components.length == type.getComponents().size()) {
                    Generic newInstance = (Generic)type.setInstance((Serializable)gvc.get(type).getGenericValue().getValue(), (DefaultGeneric[])components);
                    for (Map.Entry entry2 : gvc.entrySet().stream().filter(e -> !((Generic)e.getKey()).equals(type)).collect(Collectors.toSet())) {
                        Generic[] selectedGenerics = (Generic[])((GSBuilderDefaults.GenericValueComponents)entry2.getValue()).getComponents().entrySet().stream().filter(entry_ -> entry_.getValue() != null && ((Property)entry_.getValue()).getValue() != null).map(entry_ -> this.getOrSetInstance((Generic)entry_.getKey(), (Serializable)((Property)entry_.getValue()).getValue())).filter(gen -> gen != null).toArray(Generic[]::new);
                        if ((((GSBuilderDefaults.GenericValueComponents)entry2.getValue()).getGenericValue().getValue() != null || selectedGenerics.length != 0) && selectedGenerics.length + 1 == ((Generic)entry2.getKey()).getComponents().size()) {
                            Generic newHolder = (Generic)newInstance.setHolder((DefaultGeneric)entry2.getKey(), (Serializable)((GSBuilderDefaults.GenericValueComponents)entry2.getValue()).getGenericValue().getValue(), (DefaultGeneric[])selectedGenerics);
                            if (PasswordDefaults.class.isAssignableFrom(tag.getParent().getParent().getClass()) && context.find(User.Password.class) != null && newHolder.isInstanceOf((DefaultGeneric)context.find(User.Password.class))) {
                                newHolder.setHolder((DefaultGeneric)context.find(User.Salt.class), (Serializable)((PasswordDefaults)tag.getParent().getParent()).getSaltProperty(context).getValue(), (DefaultGeneric[])new Generic[0]);
                            }
                        }
                        ((GSBuilderDefaults.GenericValueComponents)entry2.getValue()).getComponents().values().stream().forEach(sel -> sel.setValue(null));
                        ((GSBuilderDefaults.GenericValueComponents)entry2.getValue()).getGenericValue().setValue(null);
                    }
                    gvc.get(type).getComponents().values().stream().forEach(sel -> sel.setValue(null));
                    gvc.get(type).getGenericValue().setValue(null);
                    Map relationMap = (Map)buildTag.getMultipleRelationProperty(context).getValue();
                    for (Map.Entry entry3 : relationMap.entrySet()) {
                        for (Generic target : ((Map)entry3.getValue()).keySet()) {
                            newInstance.setHolder((DefaultGeneric)entry3.getKey(), null, (DefaultGeneric[])new Generic[]{target});
                        }
                    }
                    for (Property convertedProperty : relationMap.values().stream().flatMap(hm -> hm.values().stream()).collect(Collectors.toList())) {
                        convertedProperty.setValue(null);
                    }
                    tag.getParent().getParent().find(Composite.Header.class).find(InstanceBuilder.GSHolderBuilderDiv.class).find(HtmlTag.HtmlSpan.class).addStyle(context, "display", "none");
                } else {
                    tag.getParent().getParent().find(Composite.Header.class).find(InstanceBuilder.GSHolderBuilderDiv.class).find(HtmlTag.HtmlSpan.class).addStyle(context, "display", "inline");
                }
            } else {
                log.warn("The CREATE_INSTANCE action can apply only to a tag class implementing GSBuilderDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
            }
        }

        private Generic getOrSetInstance(Generic type, Serializable value) {
            Generic instance = (Generic)type.getInstance(value, (DefaultGeneric[])new Generic[0]);
            return instance != null ? instance : (Generic)type.addInstance(value, (DefaultGeneric[])new Generic[0]);
        }
    }

    public static class CREATE_USER
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            Generic user;
            context.mount();
            HtmlTag.HtmlInputText name = tag.getParent().getParent().find(HtmlTag.HtmlInputText.class);
            HtmlTag.HtmlInputText passwordInput = tag.getParent().getParent().find(HtmlTag.HtmlInputText.class, 1);
            HtmlTag.HtmlInputText confirmPassword = tag.getParent().getParent().find(HtmlTag.HtmlInputText.class, 2);
            HtmlTag.HtmlSpan invalidUsername = tag.getParent().getParent().find(HtmlTag.HtmlSpan.class);
            HtmlTag.HtmlSpan invalidConfirmPassword = tag.getParent().getParent().find(HtmlTag.HtmlSpan.class, 1);
            String psw1 = (String)passwordInput.getDomNodeAttributes(context).get((Object)"value");
            String psw2 = (String)confirmPassword.getDomNodeAttributes(context).get((Object)"value");
            try {
                user = (Generic)context.find(User.class).addInstance((Serializable)name.getDomNodeAttributes(context).get((Object)"value"), (DefaultGeneric[])new Generic[0]);
            }
            catch (RollbackException e) {
                invalidUsername.addStyle(context, "display", "inline");
                return;
            }
            if (psw1 != null && psw1.equals(psw2)) {
                invalidConfirmPassword.addStyle(context, "display", "none");
                invalidUsername.addStyle(context, "display", "none");
                byte[] salt = EncryptionUtils.generateSalt();
                byte[] hash = EncryptionUtils.getEncryptedPassword(psw1, salt);
                Generic hashGeneric = (Generic)user.setHolder((DefaultGeneric)context.find(User.Password.class), (Serializable)hash, (DefaultGeneric[])new Generic[0]);
                hashGeneric.setHolder((DefaultGeneric)context.find(User.Salt.class), (Serializable)salt, (DefaultGeneric[])new Generic[0]);
                tag.getDisplayProperty(context).setValue((Object)"none");
                name.getDomNodeAttributes(context).put((Object)"value", (Object)"");
                passwordInput.getDomNodeAttributes(context).put((Object)"value", (Object)"");
                confirmPassword.getDomNodeAttributes(context).put((Object)"value", (Object)"");
                context.flush();
                context.unmount();
                context.flush();
            } else {
                invalidConfirmPassword.addStyle(context, "display", "inline");
                context.unmount();
            }
        }
    }

    public static class RESET_SELECTION
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            if (SelectionDefaults.class.isAssignableFrom(tag.getClass())) {
                tag.getSelectionProperty(context).setValue(null);
            } else {
                log.warn("The RESET_SELECTION action can apply only to a tag class implementing SelectionDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
            }
        }
    }

    public static class SET_SELECTION
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            if (SelectionDefaults.class.isAssignableFrom(tag.getClass())) {
                tag.getSelectionProperty(context).setValue((Object)context);
            } else {
                log.warn("The SET_SELECTION action can apply only to a tag class implementing SelectionDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
            }
        }
    }

    public static class MODAL_DISPLAY_FLEX
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            tag.getParent().find(Modal.ModalWithDisplay.class).getDisplayProperty(context).setValue((Object)"flex");
        }
    }

    public static class DISPLAY_NONE_CANCEL
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            tag.getParent().getParent().find(HtmlTag.HtmlInputText.class).getDomNodeAttributes(context).put((Object)"value", (Object)"");
            tag.getParent().getParent().find(HtmlTag.HtmlInputText.class, 1).getDomNodeAttributes(context).put((Object)"value", (Object)"");
            tag.getParent().getParent().find(HtmlTag.HtmlInputText.class, 2).getDomNodeAttributes(context).put((Object)"value", (Object)"");
            tag.getDisplayProperty(context).setValue((Object)"none");
        }
    }

    public static class DISPLAY_NONE
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            tag.getDisplayProperty(context).setValue((Object)"none");
        }
    }

    public static class GC
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            System.gc();
        }
    }

    public static class SHIFTTS
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            context.shiftTs();
        }
    }

    public static class UNMOUNT
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            context.unmount();
        }
    }

    public static class MOUNT
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            context.mount();
        }
    }

    public static class CANCEL
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            context.cancel();
        }
    }

    public static class FLASH
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            RootContext rootContext = context.getRootContext();
            Tag rootTag = rootContext.getTagDataMap().keySet().iterator().next();
            RootHtmlDomNode rootNode = (RootHtmlDomNode)rootContext.getHtmlDomNode(rootTag);
            String body = rootNode.toHTMLString();
            rootNode.toHtmlFile(rootNode.header() + body + rootNode.footer(), "html", "/home/middleware/git/genericsystem2015/gs-reactor/src/main/resources/");
        }
    }

    public static class FLUSH
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            context.flush();
        }
    }

    public static class REMOVE
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            context.remove();
        }
    }

    public static class ADD_HOLDER
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            Property<Serializable> convertedValue = ((ConvertedValueDefaults)tag.getParent()).getConvertedValueProperty(context.getParent());
            if (convertedValue.getValue() != null) {
                Serializable newValue = (Serializable)convertedValue.getValue();
                convertedValue.setValue(null);
                context.getGenerics()[1].addHolder((DefaultGeneric)context.getGeneric(), newValue, (DefaultGeneric[])new Generic[0]);
            } else if (Boolean.class.equals((Object)context.getGeneric().getInstanceValueClassConstraint())) {
                context.getGenerics()[1].addHolder((DefaultGeneric)context.getGeneric(), (Serializable)Boolean.valueOf(false), (DefaultGeneric[])new Generic[0]);
            }
        }
    }
}

