/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.context;

import java.util.HashMap;
import java.util.Map;
import javafx.collections.ObservableList;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.kernel.Cache;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;

public class RootContext
extends Context {
    private final Cache cache;
    private Map<Tag, ObservableList<Tag>> observableSubTags = new HashMap<Tag, ObservableList<Tag>>(){

        @Override
        public ObservableList<Tag> get(Object key) {
            ObservableList<Tag> result = (ObservableList<Tag>)super.get(key);
            if (result == null) {
                result = RootContext.this.build((Tag)key);
                this.put((Tag)key, result);
            }
            return result;
        }
    };

    Map<Tag, ObservableList<Tag>> getObservableSubTags() {
        return this.observableSubTags;
    }

    public ObservableList<Tag> build(Tag tag) {
        return tag.getObservableChildren();
    }

    public RootContext(Root engine, Cache cache) {
        super(null, new Generic[]{engine});
        this.cache = cache;
    }

    @Override
    public RootContext getRootContext() {
        return this;
    }

    public Cache getCache() {
        return this.cache;
    }

    public ObservableList<Tag> getObservableChildren(Tag tag) {
        return this.observableSubTags.get(tag);
    }
}

