/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.extended.ExtendedAnnotationsManager;
import org.genericsystem.reactor.extended.ExtendedRootTag;
import org.genericsystem.reactor.gscomponents.TagImpl;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=StyleClasses.class)
@Process(value=StyleClassProcessor.class)
@GenericProcess(value=StyleClassGenericProcessor.class)
public @interface StyleClass {
    public Class<? extends TagImpl>[] path() default {};

    public String[] value();

    public int[] pos() default {};

    public static class StyleClassGenericProcessor
    implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
        @Override
        public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
            gTag.setArrayValueAnnotation(StyleClass.class, null, ((StyleClass)annotation).value(), ((StyleClass)annotation).path(), ((StyleClass)annotation).pos());
        }

        @Override
        public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            for (String styleClass : (String[])annotationContent.getContentJSonArray().stream().toArray(String[]::new)) {
                tag.removeStyleClass(context, styleClass);
            }
        }

        @Override
        public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.getRootTag().processStyleClass(tag, context, annotationContent.getStringArrayContent());
        }
    }

    public static class StyleClassProcessor
    implements BiConsumer<Annotation, Tag> {
        @Override
        public void accept(Annotation annotation, Tag tag) {
            tag.getRootTag().processStyleClass(tag, ((StyleClass)annotation).value());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface StyleClasses {
        public StyleClass[] value();
    }
}

