/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.contextproperties;

import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.contextproperties.ContextProperty;
import org.genericsystem.reactor.gscomponents.FlexDirection;

public interface FlexDirectionDefaults
extends ContextProperty {
    public static final String FLEX_DIRECTION = "flexDirection";
    public static final String PARENT_DIRECTION_LISTENER = "parentDirectionListener";

    default public Property<FlexDirection> getDirectionProperty(Context context) {
        if (!context.containsAttribute((Tag)((Object)this), FLEX_DIRECTION)) {
            SimpleObjectProperty direction = new SimpleObjectProperty();
            direction.addListener((o, v, nv) -> this.addStyle(context, "flex-direction", nv != null ? nv.toString() : "column"));
            direction.setValue((Object)FlexDirection.COLUMN);
            this.addContextAttribute(FLEX_DIRECTION, context, direction);
        }
        return this.getContextProperty(FLEX_DIRECTION, context);
    }

    default public Property<ChangeListener<FlexDirection>> getDirectionListenerProperty(Context context) {
        return this.getContextProperty(PARENT_DIRECTION_LISTENER, context);
    }

    default public void setDirection(Context context, FlexDirection direction) {
        this.getDirectionProperty(context).setValue((Object)direction);
    }

    default public void setDirection(FlexDirection direction) {
        this.addPrefixBinding(context -> this.setDirection((Context)context, direction));
    }

    default public void reverseDirection(Context context) {
        this.createNewInitializedProperty(PARENT_DIRECTION_LISTENER, context, (o, v, nv) -> this.setDirection(context, nv.reverse()));
        this.startTrackingDirection(context, direction -> direction != null ? direction.reverse() : FlexDirection.ROW);
    }

    default public void reverseDirection() {
        this.addPrefixBinding(context -> this.reverseDirection((Context)context));
    }

    default public void keepDirection(Context context) {
        this.createNewInitializedProperty(PARENT_DIRECTION_LISTENER, context, (o, v, nv) -> this.setDirection(context, (FlexDirection)((Object)nv)));
        this.startTrackingDirection(context, direction -> direction);
    }

    default public void keepDirection() {
        this.addPrefixBinding(context -> this.keepDirection((Context)context));
    }

    default public void startTrackingDirection(Context context, Function<FlexDirection, FlexDirection> getInitialDirection) {
        if (!FlexDirectionDefaults.class.isAssignableFrom(((Tag)((Object)this)).getParent().getClass())) {
            throw new IllegalStateException("The class of the parent must implement FlexDirectionDefaults when reverseDirection or keepDirection is used.");
        }
        Context parentContext = ((Tag)((Object)this)).getMetaBinding() != null ? context.getParent() : context;
        Property<FlexDirection> parentDirection = ((FlexDirectionDefaults)((Tag)((Object)this)).getParent()).getDirectionProperty(parentContext);
        this.setDirection(context, getInitialDirection.apply((FlexDirection)((Object)parentDirection.getValue())));
        parentDirection.addListener((ChangeListener)this.getDirectionListenerProperty(context).getValue());
    }

    default public void stopTrackingDirection(Context context) {
        Context parentContext = ((Tag)((Object)this)).getMetaBinding() != null ? context.getParent() : context;
        Property<FlexDirection> parentDirection = ((FlexDirectionDefaults)((Tag)((Object)this)).getParent()).getDirectionProperty(parentContext);
        parentDirection.removeListener((ChangeListener)this.getDirectionListenerProperty(context).getValue());
        context.getAttributes((Tag)((Object)this)).remove(PARENT_DIRECTION_LISTENER);
    }
}

