/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.context;

import io.reactivex.Observable;
import java.text.Collator;
import java.util.Arrays;
import java.util.function.Function;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.common.Generic;
import org.genericsystem.common.Root;
import org.genericsystem.defaults.DefaultGeneric;

@FunctionalInterface
public interface ForEachExtractor
extends Function<Generic[], Observable<Snapshot<Generic>>> {
    public static final ForEachExtractor INSTANCES = generics -> Observable.just((Object)generics[0].getInstances().sorted());
    public static final ForEachExtractor SUBINSTANCES = generics -> Observable.just((Object)generics[0].getSubInstances().sorted());
    public static final ForEachExtractor SUBINSTANCES_ALPHABETICAL_ORDER = generics -> Observable.just((Object)generics[0].getSubInstances().sort((g1, g2) -> Collator.getInstance().compare(g1.toString(), g2.toString())));
    public static final ForEachExtractor SUBINSTANCES_OF_META = generics -> Observable.just((Object)generics[0].getMeta().getSubInstances().sorted());
    public static final ForEachExtractor ATTRIBUTES_OF_TYPE = generics -> Observable.just((Object)generics[0].getAttributes().filter(attribute -> attribute.isCompositeForInstances((DefaultGeneric)generics[0])).sorted());
    public static final ForEachExtractor ATTRIBUTES_OF_INSTANCES = generics -> Observable.just((Object)generics[1].getAttributes().filter(attribute -> attribute.isCompositeForInstances((DefaultGeneric)generics[1])).sorted());
    public static final ForEachExtractor COMPONENTS = generics -> Observable.just(() -> generics[0].getComponents().stream());
    public static final ForEachExtractor HOLDERS = generics -> Observable.just((Object)generics[1].getHolders((DefaultGeneric)generics[0]).sorted());
    public static final ForEachExtractor OTHER_COMPONENTS_1 = gs -> ((Observable)COMPONENTS.apply(gs)).map(s -> s.filter(g -> !gs[1].inheritsFrom((DefaultGeneric)g)));
    public static final ForEachExtractor OTHER_COMPONENTS_2 = gs -> ((Observable)COMPONENTS.apply(gs)).map(s -> s.filter(g -> !gs[2].inheritsFrom((DefaultGeneric)g)));

    public static ForEachExtractor from(Class<?> ... genericClasses) {
        return gs -> Observable.just(() -> Arrays.stream(genericClasses).map(arg_0 -> ((Root)gs[0].getRoot()).find(arg_0)));
    }

    public static class NO_FOR_EACH
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            throw new IllegalStateException();
        }
    }

    public static class HOLDERS
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)HOLDERS.apply(generics);
        }
    }

    public static class ATTRIBUTES_OF_INSTANCES
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)ATTRIBUTES_OF_INSTANCES.apply(generics);
        }
    }

    public static class SUBINSTANCES_OF_RELATION_COMPONENT
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)SUBINSTANCES.apply(((Observable)COMPONENTS.apply(generics)).map(s -> (Generic[])s.filter(g -> !generics[1].inheritsFrom((DefaultGeneric)g)).stream().toArray(Generic[]::new)).blockingFirst());
        }
    }

    public static class SUBINSTANCES_OF_LINK_COMPONENT
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)SUBINSTANCES.apply(((Observable)COMPONENTS.apply(generics)).map(s -> (Generic[])s.filter(g -> !generics[2].inheritsFrom((DefaultGeneric)g)).stream().toArray(Generic[]::new)).blockingFirst());
        }
    }

    public static class SUBINSTANCES_OF_META
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)SUBINSTANCES_OF_META.apply(generics);
        }
    }

    public static class SUBINSTANCES_ALPHABETICAL_ORDER
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)SUBINSTANCES_ALPHABETICAL_ORDER.apply(generics);
        }
    }

    public static class SUBINSTANCES
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)SUBINSTANCES.apply(generics);
        }
    }

    public static class INSTANCES
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)INSTANCES.apply(generics);
        }
    }

    public static class OTHER_COMPONENTS_2
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)OTHER_COMPONENTS_2.apply(generics);
        }
    }

    public static class OTHER_COMPONENTS_1
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)OTHER_COMPONENTS_1.apply(generics);
        }
    }

    public static class COMPONENTS
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)COMPONENTS.apply(generics);
        }
    }

    public static class ATTRIBUTES_OF_TYPE
    implements ForEachExtractor {
        @Override
        public Observable<Snapshot<Generic>> apply(Generic[] generics) {
            return (Observable)ATTRIBUTES_OF_TYPE.apply(generics);
        }
    }
}

