/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import java.lang.reflect.InvocationTargetException;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.property.Property;
import org.genericsystem.api.core.Snapshot;
import org.genericsystem.defaults.tools.RxJavaHelpers;
import org.genericsystem.reactor.AnnotationsManager;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.HtmlDomNode;
import org.genericsystem.reactor.RootHtmlDomNode;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.TagNode;
import org.genericsystem.reactor.context.ContextAction;
import org.genericsystem.reactor.context.ForEachExtractor;
import org.genericsystem.reactor.context.ForEachExtractorFromContext;
import org.genericsystem.reactor.context.GenericSelector;
import org.genericsystem.reactor.context.OptionalContextSelector;
import org.genericsystem.reactor.context.StringExtractor;
import org.genericsystem.reactor.context.TagSwitcher;
import org.genericsystem.reactor.context.TextBinding;
import org.genericsystem.reactor.contextproperties.ActionDefaults;
import org.genericsystem.reactor.contextproperties.FlexDirectionDefaults;
import org.genericsystem.reactor.contextproperties.SelectionDefaults;
import org.genericsystem.reactor.gscomponents.Controller;
import org.genericsystem.reactor.gscomponents.FlexDirection;
import org.genericsystem.reactor.gscomponents.TagImpl;

public interface RootTag
extends Tag {
    default public RootHtmlDomNode init(Context rootModelContext, String rootId, HtmlDomNode.Sender send) {
        return new RootHtmlDomNode(rootModelContext, this, rootId, send);
    }

    @Override
    default public RootTag getRootTag() {
        return this;
    }

    public AnnotationsManager getAnnotationsManager();

    default public void processAnnotations(Tag tag) {
        this.getAnnotationsManager().processAnnotations(tag);
    }

    public TagNode buildTagNode(Tag var1);

    default public void processChildren(Tag tag, Class<? extends TagImpl>[] classes) {
        for (Class<? extends TagImpl> clazz : classes) {
            tag.createChild(clazz);
        }
    }

    default public void processStyle(Tag tag, String name, String value) {
        tag.addPrefixBinding(context -> this.processStyle(tag, (Context)context, name, value));
    }

    default public void processStyle(Tag tag, Context context, String name, String value) {
        tag.addStyle(context, name, value);
    }

    default public void processAttribute(Tag tag, String name, String value) {
        tag.addPrefixBinding(context -> this.processAttribute(tag, (Context)context, name, value));
    }

    default public void processAttribute(Tag tag, Context context, String name, String value) {
        tag.addAttribute(context, name, value);
    }

    default public void processGenericValueBackgroundColor(Tag tag, String value) {
        tag.addPrefixBinding(context -> this.processGenericValueBackgroundColor(tag, (Context)context, value));
    }

    default public void processGenericValueBackgroundColor(Tag tag, Context context, String value) {
        tag.addStyle(context, "background-color", "Color".equals(StringExtractor.SIMPLE_CLASS_EXTRACTOR.apply(context.getGeneric().getMeta())) ? (String)tag.getGenericStringProperty(context).getValue() : value);
    }

    default public void processFlexDirectionStyle(Tag tag, FlexDirection flexDirection) {
        tag.addPrefixBinding(context -> this.processFlexDirectionStyle(tag, (Context)context, flexDirection));
    }

    default public void processFlexDirectionStyle(Tag tag, Context context, FlexDirection flexDirection) {
        if (FlexDirectionDefaults.class.isAssignableFrom(tag.getClass())) {
            ((FlexDirectionDefaults)((Object)tag)).setDirection(context, flexDirection);
        } else {
            log.warn("Warning: FlexDirection is applicable only to classes implementing FlexDirectionDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
        }
    }

    default public void processReverseFlexDirection(Tag tag) {
        tag.addPrefixBinding(context -> this.processReverseFlexDirection(tag, (Context)context));
    }

    default public void processReverseFlexDirection(Tag tag, Context context) {
        if (FlexDirectionDefaults.class.isAssignableFrom(tag.getClass())) {
            ((FlexDirectionDefaults)((Object)tag)).reverseDirection(context);
        } else {
            log.warn("Warning: ReverseFlexDirection is applicable only to classes implementing FlexDirectionDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
        }
    }

    default public void processKeepFlexDirection(Tag tag) {
        tag.addPrefixBinding(context -> this.processKeepFlexDirection(tag, (Context)context));
    }

    default public void processKeepFlexDirection(Tag tag, Context context) {
        if (FlexDirectionDefaults.class.isAssignableFrom(tag.getClass())) {
            ((FlexDirectionDefaults)((Object)tag)).keepDirection(context);
        } else {
            log.warn("Warning: KeepFlexDirection is applicable only to classes implementing FlexDirectionDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
        }
    }

    default public void processStyleClass(Tag tag, String[] classes) {
        tag.addPrefixBinding(context -> this.processStyleClass(tag, (Context)context, classes));
    }

    default public void processStyleClass(Tag tag, Context context, String[] classes) {
        for (String sc : classes) {
            tag.addStyleClass(context, sc);
        }
    }

    default public void processSetText(Tag tag, Class<?>[] path, String[] texts) {
        tag.addPrefixBinding(context -> this.processSetText(tag, (Context)context, path, texts));
    }

    default public void processSetText(Tag tag, Context context, Class<?>[] path, String[] texts) {
        if (texts.length == 1) {
            tag.setText(context, texts[0]);
        } else {
            tag.setText(context, texts[AnnotationsManager.position(tag, path[path.length - 1])]);
        }
    }

    default public void processBindText(Tag tag, Class<? extends TextBinding> value) {
        tag.addPrefixBinding(context -> this.processBindText(tag, (Context)context, value));
    }

    default public void processBindText(Tag tag, Context context, Class<? extends TextBinding> value) {
        if (TextBinding.GENERIC_STRING.class.equals(value)) {
            tag.bindText(context);
        } else {
            try {
                tag.bindText(context, (Observable<String>)((Observable)value.newInstance().apply(context, tag)));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    default public void processBindAction(Tag tag, Class<? extends ContextAction>[] value) {
        tag.addPrefixBinding(context -> this.processBindAction(tag, (Context)context, value));
    }

    default public void processBindAction(Tag tag, Context context, Class<? extends ContextAction>[] value) {
        if (ActionDefaults.class.isAssignableFrom(tag.getClass())) {
            tag.bindAction(context, context_ -> {
                for (Class classValue : value) {
                    try {
                        ((ContextAction)classValue.newInstance()).accept(context_, tag);
                    }
                    catch (IllegalAccessException | InstantiationException e) {
                        throw new IllegalStateException(e);
                    }
                }
            });
        } else {
            log.warn("BindAction is applicable only to tags implementing ActionDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
        }
    }

    default public void processSetStringExtractor(Tag tag, Class<? extends StringExtractor> value) {
        tag.addPrefixBinding(context -> this.processSetStringExtractor(tag, (Context)context, value));
    }

    default public void processSetStringExtractor(Tag tag, Context context, Class<? extends StringExtractor> value) {
        try {
            tag.setStringExtractor(context, value.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    default public void processSelect(Tag tag, Class<?> value) {
        if (GenericSelector.class.isAssignableFrom(value)) {
            try {
                tag.select((GenericSelector)value.newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalStateException("Select value must implement ObservableValueSelector. Given class: " + value.getName());
        }
    }

    default public void processSelectContext(Tag tag, Class<?> value) {
        if (!OptionalContextSelector.class.isAssignableFrom(value)) {
            throw new IllegalStateException("SelectContext value must implement ObservableContextSelector. Given class: " + value.getName());
        }
        tag.select__(context -> {
            try {
                return (Observable)((OptionalContextSelector)value.newInstance()).apply(context, tag);
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    default public void processForEach(Tag tag, Class<?> value) {
        if (!ForEachExtractor.class.isAssignableFrom(value)) throw new IllegalStateException("ForEach value must implement ObservableListExtractor. Given class: " + value.getName());
        try {
            if (ForEachExtractor.NO_FOR_EACH.class.equals(value)) return;
            tag.forEach((ForEachExtractor)value.newInstance());
            return;
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    default public void processForEachContext(Tag tag, Class<?> value) {
        if (!ForEachExtractorFromContext.class.isAssignableFrom(value)) {
            throw new IllegalStateException("ForEach value must implement ObservableListExtractorFromContext. Given class: " + value.getName());
        }
        tag.forEach2(context -> {
            try {
                return (Observable)((ForEachExtractorFromContext)value.getDeclaredConstructor(new Class[0]).newInstance(new Object[0])).apply(context, tag);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        });
    }

    default public void processDirectSelect(Tag tag, Class<?>[] path, Class<?>[] selects) {
        if (selects.length == 1) {
            tag.select(selects[0]);
        } else {
            tag.select(selects[AnnotationsManager.position(tag, path[path.length - 1])]);
        }
    }

    default public void processSwitch(Tag tag, Class<? extends TagSwitcher>[] value) {
        try {
            for (Class<? extends TagSwitcher> switcher : value) {
                tag.addSwitcher(switcher.newInstance());
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e);
        }
    }

    default public void processBindSelection(Tag tag, Context context, Class<? extends TagImpl> value, int valuePos) {
        if (SelectionDefaults.class.isAssignableFrom(tag.getClass())) {
            tag.bindSelection(tag.find(value, valuePos), context);
        } else {
            log.warn("BindSelection is applicable only to a class implementing SelectionDefaults. Applied to class: {}.", (Object)tag.getClass().getName());
        }
    }

    default public void processBindSelection(Tag tag, Class<? extends TagImpl> value, int valuePos) {
        tag.addPostfixBinding(context -> this.processBindSelection(tag, (Context)context, value, valuePos));
    }

    default public void processStep(Tag tag, Class<? extends TagImpl> next, String prevText, String nextText) {
        if (tag.getMetaBinding() == null) {
            tag.addPrefixBinding(context -> {
                Controller controller = Controller.get(tag, context);
                controller.addStep(tag, (Observable<Integer>)Observable.just((Object)1), next, prevText, nextText);
            });
        } else {
            Function contextOl = tag.getMetaBinding().getBetweenChildren();
            tag.getMetaBinding().setBetweenChildren(context -> {
                Controller controller = Controller.get(tag, context);
                Property<Boolean> activeProperty = controller.getActiveProperty();
                return RxJavaHelpers.valuesOf(activeProperty).switchMap(active -> {
                    if (!active.booleanValue()) {
                        return (ObservableSource)contextOl.apply((Context)context);
                    }
                    Observable ol = ((Observable)contextOl.apply((Context)context)).switchMap(s -> s.setOnChanged().map(set -> set.stream().collect(Collectors.toList())));
                    Controller.StepsStep subSteps = controller.getStep(tag);
                    if (subSteps == null) {
                        subSteps = controller.addStep(tag, (Observable<Integer>)ol.map(l -> l.size()), next, prevText, nextText);
                    }
                    Observable<Integer> indexProperty = subSteps.getIndexProperty();
                    return indexProperty.withLatestFrom((ObservableSource)ol, (index, currList) -> index >= 0 && index < currList.size() ? Snapshot.singleton(currList.get((int)index)) : Snapshot.empty());
                });
            });
        }
        tag.getRootTag().processSwitch(tag, new Class[]{Controller.MainSwitcher.class});
    }

    default public void processTagName(Tag tag, String tagName, String type) {
        tag.setTag(tagName);
        if ("input".equals(tagName)) {
            tag.addAttribute("type", type);
        }
        block7 : switch (tagName.toLowerCase()) {
            case "input": {
                switch (type.toLowerCase()) {
                    case "checkbox": 
                    case "radio": {
                        tag.setDomNodeClass(HtmlDomNode.HtmlDomNodeCheckbox.class);
                        break block7;
                    }
                }
                tag.setDomNodeClass(HtmlDomNode.HtmlDomNodeInputText.class);
                break;
            }
            case "datalist": 
            case "select": {
                tag.setDomNodeClass(HtmlDomNode.HtmlDomNodeSelect.class);
                break;
            }
            case "button": 
            case "a": {
                tag.setDomNodeClass(HtmlDomNode.HtmlDomNodeAction.class);
            }
        }
    }

    default public void initDomNode(HtmlDomNode domNode) {
    }
}

