/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.extended.ExtendedAnnotationsManager;
import org.genericsystem.reactor.extended.ExtendedRootTag;
import org.genericsystem.reactor.gscomponents.TagImpl;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Repeatable(value=Attributes.class)
@Process(value=AttributeProcessor.class, repeatable=true)
@GenericProcess(value=AttributeGenericProcessor.class)
public @interface Attribute {
    public Class<? extends TagImpl>[] path() default {};

    public String name();

    public String value();

    public int[] pos() default {};

    public static class AttributeGenericProcessor
    implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
        @Override
        public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
            Attribute annotation_ = (Attribute)annotation;
            gTag.setAnnotation(Attribute.class, annotation_.name(), annotation_.value(), annotation_.path(), annotation_.pos());
        }

        @Override
        public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.getDomNodeAttributes(context).remove((Object)gTagAnnotation.getValue().getName());
        }

        @Override
        public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.getRootTag().processAttribute(tag, context, gTagAnnotation.getValue().getName(), annotationContent.getContentValue());
        }
    }

    public static class AttributeProcessor
    implements BiConsumer<Annotation, Tag> {
        @Override
        public void accept(Annotation annotation, Tag tag) {
            tag.getRootTag().processAttribute(tag, ((Attribute)annotation).name(), ((Attribute)annotation).value());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Attributes {
        public Attribute[] value();
    }
}

