/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.extended;

import java.lang.annotation.Annotation;
import java.util.LinkedHashMap;
import java.util.Map;
import javafx.collections.transformation.SortedList;
import org.genericsystem.reactor.AnnotationsManager;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.RootTag;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.Attribute;
import org.genericsystem.reactor.annotations.BindAction;
import org.genericsystem.reactor.annotations.BindSelection;
import org.genericsystem.reactor.annotations.BindText;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.annotations.DirectSelect;
import org.genericsystem.reactor.annotations.ForEach;
import org.genericsystem.reactor.annotations.ForEachContext;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.InheritStyle;
import org.genericsystem.reactor.annotations.Select;
import org.genericsystem.reactor.annotations.SelectContext;
import org.genericsystem.reactor.annotations.SetStringExtractor;
import org.genericsystem.reactor.annotations.SetText;
import org.genericsystem.reactor.annotations.Step;
import org.genericsystem.reactor.annotations.Stepper;
import org.genericsystem.reactor.annotations.Style;
import org.genericsystem.reactor.annotations.StyleClass;
import org.genericsystem.reactor.annotations.Switch;
import org.genericsystem.reactor.annotations.TagName;
import org.genericsystem.reactor.extended.ExtendedRootTag;

public class ExtendedAnnotationsManager
extends AnnotationsManager {
    private Map<Class<? extends Annotation>, IGenericAnnotationProcessor> processors;

    public Map<Class<? extends Annotation>, IGenericAnnotationProcessor> getProcessors() {
        return this.processors;
    }

    public ExtendedAnnotationsManager(Class<? extends RootTag> clazz) {
        super(clazz);
    }

    @Override
    public void initManager(Class<? extends RootTag> clazz) {
        this.processors = new LinkedHashMap<Class<? extends Annotation>, IGenericAnnotationProcessor>();
        this.registerAnnotation(Children.class);
        this.registerAnnotation(DirectSelect.class);
        this.registerAnnotation(Select.class);
        this.registerAnnotation(SelectContext.class);
        this.registerAnnotation(ForEach.class);
        this.registerAnnotation(ForEachContext.class);
        this.registerAnnotation(Stepper.class);
        this.registerAnnotation(Step.class);
        this.registerAnnotation(BindSelection.class);
        this.registerAnnotation(SetStringExtractor.class);
        this.registerAnnotation(TagName.class);
        this.registerAnnotation(StyleClass.class);
        this.registerAnnotation(Style.FlexDirectionStyle.class);
        this.registerAnnotation(Style.KeepFlexDirection.class);
        this.registerAnnotation(Style.ReverseFlexDirection.class);
        this.registerAnnotation(SetText.class);
        this.registerAnnotation(BindText.class);
        this.registerAnnotation(BindAction.class);
        this.registerAnnotation(Style.class);
        this.registerAnnotation(Style.GenericValueBackgroundColor.class);
        this.registerAnnotation(InheritStyle.class);
        this.registerAnnotation(Attribute.class);
        this.registerAnnotation(Switch.class);
        this.registerCustomAnnotations(clazz);
    }

    @Override
    public void processAnnotations(Tag tag) {
        ExtendedRootTag.GenericTagNode tagNode = (ExtendedRootTag.GenericTagNode)tag.getTagNode();
        for (Map.Entry<ExtendedRootTag.AnnotationClassName, SortedList<ExtendedRootTag.GenericAnnotationWithContent>> entry : tagNode.getSortedAnnotationsLists().entrySet()) {
            Class<? extends Annotation> annotationClass = entry.getKey().getAnnotationClass();
            if (!this.processors.containsKey(annotationClass)) continue;
            ExtendedRootTag.GenericAnnotationWithContent applyingAnnotation = (ExtendedRootTag.GenericAnnotationWithContent)entry.getValue().get(0);
            this.processors.get(annotationClass).onAdd(tag, applyingAnnotation.getgTagAnnotation(), applyingAnnotation.getAnnotationContent());
            entry.getValue().addListener(((ExtendedRootTag)tag.getRootTag()).getApplyingAnnotationsListener(tag, annotationClass));
        }
        super.processAnnotations(tag);
    }

    @Override
    public void registerAnnotation(Class<? extends Annotation> annotationClass) {
        GenericProcess processAnnotation = annotationClass.getAnnotation(GenericProcess.class);
        if (processAnnotation != null) {
            try {
                this.processors.put(annotationClass, processAnnotation.value().newInstance());
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        } else {
            log.warn("Unable to find a generic processor for annotation: {}.", (Object)annotationClass.getSimpleName());
        }
    }

    public static interface IGenericAnnotationProcessor {
        public void setAnnotation(ExtendedRootTag.GTag var1, Annotation var2);

        public void onRemove(Tag var1, Context var2, ExtendedRootTag.GTagAnnotation var3, ExtendedRootTag.GTagAnnotationContent var4);

        public void onAdd(Tag var1, Context var2, ExtendedRootTag.GTagAnnotation var3, ExtendedRootTag.GTagAnnotationContent var4);

        default public void onRemove(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.addPrefixBinding(context -> this.onRemove(tag, (Context)context, gTagAnnotation, annotationContent));
        }

        default public void onAdd(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.addPrefixBinding(context -> this.onAdd(tag, (Context)context, gTagAnnotation, annotationContent));
        }
    }
}

