/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.appserver;

import io.vertx.core.AbstractVerticle;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Verticle;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpHeaders;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.impl.ConcurrentHashSet;
import io.vertx.core.json.JsonObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.genericsystem.common.AbstractBackEnd;
import org.genericsystem.common.AbstractWebSocketsServer;
import org.genericsystem.common.GSBuffer;
import org.genericsystem.common.GSVertx;
import org.genericsystem.common.Root;
import org.genericsystem.kernel.Cache;
import org.genericsystem.reactor.HtmlDomNode;
import org.genericsystem.reactor.RootHtmlDomNode;
import org.genericsystem.reactor.RootTag;
import org.genericsystem.reactor.appserver.PersistentApplication;
import org.genericsystem.reactor.appserver.WebAppsConfig;
import org.genericsystem.reactor.gscomponents.RootTagImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ApplicationServer
extends AbstractBackEnd {
    protected static Logger log = LoggerFactory.getLogger(ApplicationServer.class);
    protected Map<String, PersistentApplication> apps = new HashMap<String, PersistentApplication>();

    public ApplicationServer(WebAppsConfig options) {
        super(options.getHost(), options.getPort());
        log.info("Load config : \n{}", (Object)options.encodePrettily());
        for (String directoryPath : options.getPersistentDirectoryPaths()) {
            String path = directoryPath != null ? directoryPath : "/";
            Root root = this.buildRoot(directoryPath, options.getClasses(directoryPath), options.getEngineClass(directoryPath));
            log.info("Starts {} with path: {} and persistence directory path: {}.", new Object[]{root.getClass().getSimpleName(), path, directoryPath});
            if (directoryPath == null) {
                directoryPath = "/";
            }
            this.roots.put(path, root);
        }
        for (String applicationPath : options.getApplicationsPaths()) {
            String directoryPath = options.getPersistentDirectoryPath(applicationPath);
            String path = directoryPath != null ? directoryPath : "/";
            this.apps.put(applicationPath, new PersistentApplication(options.getApplicationClass(applicationPath), options.getModelClass(applicationPath), (Root)this.roots.get(path), options.getRootId()));
        }
    }

    public static ApplicationServer startSimpleGenericApp(String[] mainArgs, Class<? extends RootTagImpl> htmlAppClass, String homePersistentDirectoryPath) {
        ApplicationServer server = new ApplicationServer(new WebAppsConfig.SimpleWebAppConfig(mainArgs, htmlAppClass, homePersistentDirectoryPath));
        server.start();
        return server;
    }

    protected Root buildRoot(String persistentDirectoryPath, Set<Class<?>> userClasses, Class<? extends Root> applicationClass) {
        try {
            return applicationClass.getConstructor(String.class, Class[].class).newInstance(persistentDirectoryPath, userClasses.toArray(new Class[userClasses.size()]));
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    protected WebSocketsServer buildWebSocketsServer(String host, int port) {
        return new WebSocketsServer(host, port);
    }

    private class WebSocketsServer
    extends AbstractWebSocketsServer {
        private Set<CacheSocket> caches;

        public WebSocketsServer(String host, int port) {
            super(host, port);
            this.caches = new ConcurrentHashSet();
        }

        public Handler<Buffer> getHandler(String path, ServerWebSocket webSocket) {
            PersistentApplication application = ApplicationServer.this.apps.get(path);
            if (application == null) {
                throw new IllegalStateException("Unable to load an application with path : " + path);
            }
            Cache cache = (Cache)application.getEngine().newCache();
            cache.enableReactive();
            DomNodeVerticle domNodeVerticle = new DomNodeVerticle(cache, webSocket, application);
            GSVertx.vertx().getVertx().deployVerticle((Verticle)domNodeVerticle, new DeploymentOptions().setWorker(true));
            this.caches.add(new CacheSocket(cache, webSocket, domNodeVerticle));
            return buffer -> {
                GSBuffer gsBuffer = new GSBuffer(buffer);
                String message = gsBuffer.getString(0, gsBuffer.length());
                JsonObject json = new JsonObject(message);
                RootHtmlDomNode rootHtmlDomNode = domNodeVerticle.getRootHtmlDomNode();
                if (rootHtmlDomNode != null) {
                    HtmlDomNode node = rootHtmlDomNode.getNodeById(json.getString("nodeId"));
                    if (node != null) {
                        cache.safeExecute(() -> node.handleMessage(json));
                    } else {
                        log.info("Can't find node with id: {}.", (Object)json.getString("nodeId"));
                    }
                } else {
                    log.info("The DOM node tree has not been fully built yet.");
                }
            };
        }

        public Handler<Void> getCloseHandler(ServerWebSocket socket) {
            return v -> {
                for (CacheSocket cacheSocketContext : this.caches) {
                    if (!socket.equals(cacheSocketContext.getSocket())) continue;
                    if (cacheSocketContext.getDomNodeVerticle().getRootHtmlDomNode() != null) {
                        cacheSocketContext.getDomNodeVerticle().getRootHtmlDomNode().getModelContext().destroy();
                    }
                    cacheSocketContext.getCache().disableReactive();
                    this.caches.remove(cacheSocketContext);
                }
            };
        }

        public void addHttpHandler(HttpServer httpServer) {
            httpServer.requestHandler(request -> {
                PersistentApplication application;
                String appPath;
                String[] items = request.path().substring(1).split("/");
                String string = appPath = items.length == 0 ? "" : items[0];
                if (appPath.endsWith(".js") || appPath.endsWith(".css") || appPath.endsWith(".ico") || appPath.endsWith(".jpg") || appPath.endsWith(".png")) {
                    appPath = "";
                }
                if ((application = ApplicationServer.this.apps.get("/" + appPath)) == null) {
                    request.response().end("No application is configured with path : /" + appPath);
                    log.error("No application is configured with path : /{}.", (Object)appPath);
                    return;
                }
                int shift = appPath.isEmpty() ? 0 : 1;
                String resourceToServe = request.path().substring(appPath.length() + (shift += items.length > shift ? 1 : 0));
                if ("".equals(resourceToServe)) {
                    String indexHtml = "<!DOCTYPE html>";
                    indexHtml = indexHtml + "<html>";
                    indexHtml = indexHtml + "<head>";
                    indexHtml = indexHtml + "<meta charset=\"UTF-8\" name=\"viewport\" content=\"width=device-width, initial-scale=1.0\">";
                    indexHtml = indexHtml + "<LINK rel=stylesheet type=\"text/css\" href=\"/reactor.css\"/>";
                    indexHtml = indexHtml + "<LINK rel=stylesheet type=\"text/css\" href=\"" + (appPath.isEmpty() ? "" : "/" + appPath) + "/" + application.getApplicationClass().getSimpleName().toLowerCase() + ".css\"/>";
                    indexHtml = indexHtml + "<LINK rel=stylesheet type=\"text/css\" href=\"https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css\"/>";
                    indexHtml = indexHtml + "<script>";
                    indexHtml = indexHtml + "var serviceLocation = \"ws://\" + document.location.host + \"" + request.path() + "\";";
                    indexHtml = indexHtml + "</script>";
                    indexHtml = indexHtml + "<script type=\"text/javascript\" src=\"/script.js\"></script>";
                    indexHtml = indexHtml + "<script type=\"text/javascript\" src=\"" + (appPath.isEmpty() ? "" : "/" + appPath) + "/" + application.getApplicationClass().getSimpleName().toLowerCase() + ".js\"></script>";
                    indexHtml = indexHtml + "</head>";
                    indexHtml = indexHtml + "<body onload=\"connect();\" id=\"" + application.getRootId() + "\">";
                    indexHtml = indexHtml + "</body>";
                    indexHtml = indexHtml + "</html>";
                    application.setIndexHtml(indexHtml);
                    request.response().headers().add(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
                    request.response().end(indexHtml);
                } else {
                    InputStream input = application.getApplicationClass().getResourceAsStream("/" + resourceToServe);
                    if (input == null) {
                        if (resourceToServe.endsWith(".css")) {
                            log.warn("Unable to find resource : /{}, get the reactor standard reactor.css instead", (Object)resourceToServe);
                            input = ApplicationServer.class.getResourceAsStream("/reactor.css");
                        } else if (resourceToServe.endsWith(".js")) {
                            log.warn("Unable to find resource : /{}, get the reactor standard script.js instead", (Object)resourceToServe);
                            input = ApplicationServer.class.getResourceAsStream("/script.js");
                        } else if (resourceToServe.endsWith("favicon.ico")) {
                            log.warn("Unable to find resource : /{}, get the reactor standard favicon.ico instead", (Object)resourceToServe);
                            input = ApplicationServer.class.getResourceAsStream("/favicon.ico");
                        } else {
                            if (resourceToServe.endsWith(".ico") || resourceToServe.endsWith(".jpg") || resourceToServe.endsWith(".png")) {
                                log.warn("Unable to find resource : /{}, get nothing instead.", (Object)resourceToServe);
                                request.response().end();
                                return;
                            }
                            throw new IllegalStateException("Unable to find resource : " + resourceToServe);
                        }
                    }
                    if (resourceToServe.endsWith(".ico")) {
                        MultiMap headers = request.response().headers();
                        Buffer buffer = this.makeBuffer(input);
                        headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)"image/x-icon");
                        headers.add(HttpHeaders.CONTENT_LENGTH, (CharSequence)Integer.toString(buffer.length()));
                        headers.add(HttpHeaders.CACHE_CONTROL, (CharSequence)"public, max-age=86400");
                        request.response().end(buffer);
                    } else if (resourceToServe.endsWith(".jpg") || resourceToServe.endsWith(".png")) {
                        MultiMap headers = request.response().headers();
                        Buffer buffer = this.makeBuffer(input);
                        headers.add(HttpHeaders.CONTENT_LENGTH, (CharSequence)Integer.toString(buffer.length()));
                        headers.add(HttpHeaders.CACHE_CONTROL, (CharSequence)"public, max-age=86400");
                        request.response().end(buffer);
                    } else {
                        String result = new BufferedReader(new InputStreamReader(input)).lines().collect(Collectors.joining("\n"));
                        MultiMap headers = request.response().headers();
                        if (resourceToServe.endsWith(".css")) {
                            headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/css");
                        } else if (resourceToServe.endsWith(".js")) {
                            headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)"application/javascript");
                        } else {
                            headers.add(HttpHeaders.CONTENT_TYPE, (CharSequence)"text/html");
                        }
                        request.response().end(result);
                    }
                }
            });
        }

        private Buffer makeBuffer(InputStream input) {
            Buffer buffer = Buffer.buffer();
            byte[] data = new byte[4096];
            try {
                int read;
                while ((read = input.read(data, 0, data.length)) != -1) {
                    if (read == data.length) {
                        buffer.appendBytes(data);
                        continue;
                    }
                    byte[] slice = new byte[read];
                    System.arraycopy(data, 0, slice, 0, slice.length);
                    buffer.appendBytes(slice);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
            return buffer;
        }

        public void start() {
            super.start();
            String logo = "\n";
            logo = logo + "____________________________________________________________________________________________________________\n";
            logo = logo + "|___________________________________________________________________________________________________________|\n";
            logo = logo + "|___________________________________________________________________________________________________________|\n";
            logo = logo + "|____________|         ____                      _      ____             __                  /______________|\n";
            logo = logo + "|____________|        / ___)___  _  _____  ___  /_)__  / ___)_  __ ___  / /  ___  ____      /_______________|\n";
            logo = logo + "|____________|       / /___/ __)/ \\/ / __)/ _ )/ |/ _)/___ \\/ \\/  ) __)/___)/ __)/    )    /________________|\n";
            logo = logo + "|____________|      / /_  / __)/    / __)/   \\/  / /_ ___/ /\\    (__  / /_ / __)/ / / /   /_________________|\n";
            logo = logo + "|____________|      \\____(____(_/\\_(____(_/\\_(__(____(____/  \\  (____(____(____(_/_/_/   /__________________|\n";
            logo = logo + "|____________|                                               /_/                        /___________________|\n";
            logo = logo + "|____________|_________________________________________________________________________/____________________|\n";
            logo = logo + "|___________________________________________________________________________________________________________|\n";
            logo = logo + "|___________________________________________________________________________________________________________|  \n";
            log.info(logo);
            log.info("Generic System Server is ready!");
        }
    }

    private class CacheSocket {
        private final Cache cache;
        private final ServerWebSocket socket;
        private final DomNodeVerticle domNodeVerticle;

        public CacheSocket(Cache cache, ServerWebSocket socket, DomNodeVerticle domNodeVerticle) {
            this.cache = cache;
            this.socket = socket;
            this.domNodeVerticle = domNodeVerticle;
        }

        public Cache getCache() {
            return this.cache;
        }

        public ServerWebSocket getSocket() {
            return this.socket;
        }

        public DomNodeVerticle getDomNodeVerticle() {
            return this.domNodeVerticle;
        }
    }

    private static class DomNodeVerticle
    extends AbstractVerticle {
        private Cache cache;
        private ServerWebSocket socket;
        private PersistentApplication application;
        private RootTag tagTree;
        private RootHtmlDomNode rootHtmlDomNode;

        DomNodeVerticle(Cache cache, ServerWebSocket socket, PersistentApplication application) {
            this.cache = cache;
            this.socket = socket;
            this.application = application;
        }

        public void start(Future<Void> startFuture) {
            GSVertx.vertx().getVertx().executeBlocking(future -> {
                try {
                    this.tagTree = this.application.getApplicationClass().newInstance();
                }
                catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
                    try {
                        this.cache.start();
                        this.tagTree = this.application.getApplicationClass().getConstructor(Root.class).newInstance(this.application.getEngine());
                        this.cache.flush();
                        this.cache.stop();
                    }
                    catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException ex) {
                        throw new IllegalStateException(ex);
                    }
                }
                RootHtmlDomNode result = (RootHtmlDomNode)this.cache.safeSupply(() -> this.application.init(s -> {
                    try {
                        this.socket.writeFinalTextFrame(s);
                    }
                    catch (IllegalStateException illegalStateException) {
                        // empty catch block
                    }
                }, this.tagTree, this.cache));
                future.complete((Object)result);
            }, res -> {
                if (res.succeeded()) {
                    this.rootHtmlDomNode = (RootHtmlDomNode)res.result();
                } else {
                    log.error("Failed to build tag tree.", res.cause());
                }
            });
        }

        RootHtmlDomNode getRootHtmlDomNode() {
            return this.rootHtmlDomNode;
        }
    }
}

