/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.gscomponents;

import io.reactivex.Observable;
import io.reactivex.ObservableSource;
import io.reactivex.subjects.BehaviorSubject;
import io.reactivex.subjects.ReplaySubject;
import io.reactivex.subjects.Subject;
import java.util.Map;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.genericsystem.defaults.tools.RxJavaHelpers;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.context.ContextAction;
import org.genericsystem.reactor.context.TagSwitcher;
import org.genericsystem.reactor.context.TextBinding;
import org.genericsystem.reactor.gscomponents.TagImpl;

public class Controller {
    public static final String CONTROLLER = "controller";
    private final Tag containerTag;
    private final Subject<Class<? extends Tag>> classProperty;
    private final Subject<Integer> globalIncs = ReplaySubject.create();
    private final ObservableMap<Tag, StepsStep> steps = FXCollections.observableHashMap();
    private Property<Boolean> activeProperty = new SimpleBooleanProperty(true);

    public static void initialize(Tag tag, Class<? extends TagImpl> firstClass) {
        tag.setContextAttribute(CONTROLLER, c -> new Controller(tag, firstClass));
    }

    public static Controller get(Tag tag, Context context) {
        return (Controller)tag.getContextAttribute(CONTROLLER, context);
    }

    public Controller(Tag containerTag, Class<? extends TagImpl> firstClass) {
        this.containerTag = containerTag;
        this.classProperty = BehaviorSubject.create();
        this.classProperty.onNext(firstClass);
    }

    public Observable<Class<? extends Tag>> getClassProperty() {
        return this.classProperty.hide();
    }

    public Property<Boolean> getActiveProperty() {
        return this.activeProperty;
    }

    public void setActiveProperty(boolean active) {
        this.activeProperty.setValue((Object)active);
    }

    public StepsStep getStep(Tag tag) {
        Tag tag_ = tag;
        StepsStep result = null;
        while (result == null && !this.containerTag.equals(tag_)) {
            result = (StepsStep)this.steps.get((Object)tag_);
            tag_ = tag_.getParent();
        }
        return result;
    }

    public StepsStep addStep(Tag tag, Observable<Integer> observableSize, Class<? extends TagImpl> nextClass, String prevText, String nextText) {
        StepsStep result = new StepsStep(tag, observableSize, nextClass, prevText, nextText);
        this.steps.put((Object)tag, (Object)result);
        return result;
    }

    public Observable<String> prevText(Tag tag) {
        return this.getStep(tag).prevText();
    }

    public Observable<String> nextText(Tag tag) {
        return this.getStep(tag).nextText();
    }

    public void previous(Tag tag) {
        this.getStep(tag).prev();
    }

    public void next(Tag tag) {
        this.getStep(tag).next();
    }

    public Observable<Boolean> hasPrev(Tag tag) {
        return this.getStep(tag).hasPrev();
    }

    public Observable<Boolean> hasNext(Tag tag) {
        return this.getStep(tag).hasNext();
    }

    public StepsStep getStep(Class<? extends TagImpl> clazz) {
        for (Map.Entry entry : this.steps.entrySet()) {
            if (!((Tag)entry.getKey()).getClass().equals(clazz)) continue;
            return (StepsStep)entry.getValue();
        }
        return null;
    }

    public StepsStep getPreviousStep(Class<? extends Tag> clazz) {
        for (Map.Entry entry : this.steps.entrySet()) {
            if (!((StepsStep)entry.getValue()).getNextClass().equals(clazz) || ((StepsStep)entry.getValue()).getNextClass().equals(((StepsStep)entry.getValue()).getTag().getClass())) continue;
            return (StepsStep)entry.getValue();
        }
        return null;
    }

    public Observable<String> countText(Tag tag) {
        return this.globalIncs.hide().scan((Object)0, (sum, curr) -> sum + curr).map(ind -> "Step: " + Integer.toString(ind + 1));
    }

    public static class LastSwitcher
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            return Controller.get(tag, context).hasNext(tag).map(bool -> bool == false);
        }
    }

    public static class NextSwitcher
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            return Controller.get(tag, context).hasNext(tag);
        }
    }

    public static class PrevSwitcher
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            return Controller.get(tag, context).hasPrev(tag);
        }
    }

    public static class CountTextSwitcher
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            return RxJavaHelpers.valuesOf((ObservableValue)Controller.get(tag, context).activeProperty);
        }
    }

    public static class NextTextBinding
    implements TextBinding {
        @Override
        public Observable<String> apply(Context context, Tag tag) {
            return Controller.get(tag, context).nextText(tag);
        }
    }

    public static class PrevTextBinding
    implements TextBinding {
        @Override
        public Observable<String> apply(Context context, Tag tag) {
            return Controller.get(tag, context).prevText(tag);
        }
    }

    public static class CountTextBinding
    implements TextBinding {
        @Override
        public Observable<String> apply(Context context, Tag tag) {
            return Controller.get(tag, context).countText(tag);
        }
    }

    public static class NextAction
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            Controller.get(tag, context).next(tag);
        }
    }

    public static class PrevAction
    implements ContextAction {
        @Override
        public void accept(Context context, Tag tag) {
            Controller.get(tag, context).previous(tag);
        }
    }

    public static class MainSwitcher
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            Controller controller = Controller.get(tag, context);
            Property<Boolean> activeProperty = controller.getActiveProperty();
            return Observable.combineLatest((ObservableSource)RxJavaHelpers.valuesOf(activeProperty), controller.getClassProperty(), (active, clazz) -> active == false || tag.getClass().equals(clazz));
        }
    }

    public class StepsStep {
        private final Tag tag;
        private final Class<? extends TagImpl> nextClass;
        private final Subject<Integer> inc = ReplaySubject.create();
        private final Observable<Integer> observableSize;
        private final Observable<Integer> indexProperty;
        private final Observable<Boolean> hasPrev;
        private final Observable<Boolean> hasNext;
        private final Observable<String> prevText;
        private final Observable<String> nextText;

        public StepsStep(Tag tag, Observable<Integer> observableSize, Class<? extends TagImpl> nextClass, String prevText, String nextText) {
            this.tag = tag;
            this.observableSize = observableSize;
            this.indexProperty = observableSize.switchMap(size -> this.inc.hide().scan((Object)0, (curr, inc) -> {
                int newIndex = curr + inc;
                if (newIndex >= 0 && newIndex < size) {
                    return newIndex;
                }
                if (inc == -1) {
                    Controller.this.classProperty.onNext(Controller.this.getPreviousStep(tag.getClass()).getTag().getClass());
                } else {
                    Controller.this.classProperty.onNext((Object)nextClass);
                }
                return curr;
            })).distinctUntilChanged().replay().refCount();
            this.nextClass = nextClass;
            this.hasPrev = Observable.combineLatest(this.getIndexProperty(), (ObservableSource)RxJavaHelpers.valuesOf((ObservableValue)Controller.this.activeProperty), (index, active) -> active != false && (Controller.this.getPreviousStep(tag.getClass()) != null || index > 0));
            this.hasNext = Observable.combineLatest(this.getIndexProperty(), (ObservableSource)RxJavaHelpers.valuesOf((ObservableValue)Controller.this.activeProperty), observableSize, (index, active, size) -> active != false && (!tag.getClass().equals(nextClass) || index + 1 < size));
            this.prevText = Observable.just((Object)prevText);
            this.nextText = Observable.just((Object)nextText);
        }

        private Tag getTag() {
            return this.tag;
        }

        public Object getNextClass() {
            return this.nextClass;
        }

        public StepsStep getNextStep() {
            return !this.tag.getClass().equals(this.nextClass) ? Controller.this.getStep(this.nextClass) : null;
        }

        public Observable<Integer> getIndexProperty() {
            return this.indexProperty;
        }

        public Observable<Integer> getObservableSize() {
            return this.observableSize;
        }

        public void prev() {
            if (((Boolean)Controller.this.activeProperty.getValue()).booleanValue()) {
                this.inc.onNext((Object)-1);
                Controller.this.globalIncs.onNext((Object)-1);
            }
        }

        public void next() {
            if (((Boolean)Controller.this.activeProperty.getValue()).booleanValue()) {
                this.inc.onNext((Object)1);
                Controller.this.globalIncs.onNext((Object)1);
            }
        }

        public Observable<Boolean> hasPrev() {
            return this.hasPrev;
        }

        public Observable<Boolean> hasNext() {
            return this.hasNext;
        }

        public Observable<String> prevText() {
            return this.prevText;
        }

        public Observable<String> nextText() {
            return this.nextText;
        }
    }
}

