/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.genericsystem.api.core.TagAnnotation;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.extended.ExtendedAnnotationsManager;
import org.genericsystem.reactor.extended.ExtendedRootTag;
import org.genericsystem.reactor.gscomponents.TagImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Process(value=BindSelectionProcessor.class)
@GenericProcess(value=BindSelectionGenericProcessor.class)
public @interface BindSelection {
    public Class<? extends TagImpl>[] path() default {};

    public Class<? extends TagImpl> value();

    public int[] pos() default {};

    public int valuePos() default 0;

    public static class BindSelectionGenericProcessor
    implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
        @Override
        public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
            BindSelection annotation_ = (BindSelection)annotation;
            ExtendedRootTag.GTagAnnotation gTagAnnotation = (ExtendedRootTag.GTagAnnotation)gTag.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationAttribute.class), (Serializable)new TagAnnotation(BindSelection.class, (Class[])annotation_.path(), annotation_.pos()), (DefaultGeneric[])new Generic[0]);
            gTagAnnotation.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationContentAttribute.class), (Serializable)((Object)new JsonObject().put("value", annotation_.value().getName()).put("valuePos", Integer.valueOf(annotation_.valuePos())).encodePrettily()), (DefaultGeneric[])new Generic[0]);
        }

        @Override
        public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.unbindSelection((Tag)tag.find(annotationContent.getClassContent(), annotationContent.getJsonValue().getInteger("valuePos")), context);
        }

        @Override
        public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.getRootTag().processBindSelection(tag, context, annotationContent.getClassContent(), annotationContent.getJsonValue().getInteger("valuePos"));
        }

        @Override
        public void onRemove(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.addPostfixBinding(context -> this.onRemove(tag, (Context)context, gTagAnnotation, annotationContent));
        }

        @Override
        public void onAdd(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            tag.addPostfixBinding(context -> this.onAdd(tag, (Context)context, gTagAnnotation, annotationContent));
        }
    }

    public static class BindSelectionProcessor
    implements BiConsumer<Annotation, Tag> {
        private static final Logger log = LoggerFactory.getLogger(BindSelectionProcessor.class);

        @Override
        public void accept(Annotation annotation, Tag tag) {
            tag.getRootTag().processBindSelection(tag, ((BindSelection)annotation).value(), ((BindSelection)annotation).valuePos());
        }
    }
}

