/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.genericsystem.api.core.TagAnnotation;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.extended.ExtendedAnnotationsManager;
import org.genericsystem.reactor.extended.ExtendedRootTag;
import org.genericsystem.reactor.gscomponents.Controller;
import org.genericsystem.reactor.gscomponents.TagImpl;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Process(value=StepperProcessor.class)
@GenericProcess(value=StepperGenericProcessor.class)
public @interface Stepper {
    public Class<? extends TagImpl> first();

    public Class<? extends TagImpl>[] path() default {};

    public int[] pos() default {};

    public static class StepperGenericProcessor
    implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
        @Override
        public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
            Stepper stepper = (Stepper)annotation;
            ExtendedRootTag.GTagAnnotation gTagAnnotation = (ExtendedRootTag.GTagAnnotation)gTag.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationAttribute.class), (Serializable)new TagAnnotation(Stepper.class, (Class[])stepper.path(), stepper.pos()), (DefaultGeneric[])new Generic[0]);
            gTagAnnotation.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationContentAttribute.class), (Serializable)((Object)new JsonObject().put("first", stepper.first().getName()).encodePrettily()), (DefaultGeneric[])new Generic[0]);
        }

        @Override
        public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            Controller.get(tag, context).setActiveProperty(false);
        }

        @Override
        public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            if (tag.getMetaBinding() == null) {
                context.removeTag(tag);
                context.addTag(tag);
            } else {
                context.getParent().removeTag(tag);
                context.getParent().addTag(tag);
            }
        }

        @Override
        public void onAdd(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            JsonObject content = gTagAnnotation.getContent().getJsonValue();
            Class<?> first = null;
            try {
                first = Class.forName(content.getString("first"));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class " + content.getString("first") + " not found");
            }
            Controller.initialize(tag, first);
        }
    }

    public static class StepperProcessor
    implements BiConsumer<Annotation, Tag> {
        @Override
        public void accept(Annotation annotation, Tag tag) {
            Controller.initialize(tag, ((Stepper)annotation).first());
        }
    }
}

