/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.appserver;

import java.lang.reflect.InvocationTargetException;
import org.genericsystem.common.AbstractCache;
import org.genericsystem.common.Root;
import org.genericsystem.kernel.Cache;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.HtmlDomNode;
import org.genericsystem.reactor.RootHtmlDomNode;
import org.genericsystem.reactor.RootTag;
import org.genericsystem.reactor.annotations.RunScript;
import org.genericsystem.reactor.appserver.Script;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistentApplication {
    private final Class<? extends RootTag> htmlAppClass;
    private final Root engine;
    private final Class<Context> modelClass;
    private final String rootId;
    private String indexHtml = "";
    protected static Logger log = LoggerFactory.getLogger(PersistentApplication.class);

    public PersistentApplication(Class<? extends RootTag> htmlAppClass, Class<Context> modelClass, Root engine, String rootId) {
        this.htmlAppClass = htmlAppClass;
        this.modelClass = modelClass;
        this.engine = engine;
        this.rootId = rootId;
        RunScript script = this.getApplicationClass().getAnnotation(RunScript.class);
        if (script != null) {
            Script runner;
            AbstractCache cache = engine.newCache();
            log.info("Script will run ...");
            try {
                runner = script.value().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
            cache.safeExecute(() -> runner.run(this.getEngine()));
            log.info("Script has run");
        }
    }

    public String getRootId() {
        return this.rootId;
    }

    public Root getEngine() {
        return this.engine;
    }

    public Class<? extends RootTag> getApplicationClass() {
        return this.htmlAppClass;
    }

    public void close() {
        this.engine.close();
    }

    public String getIndexHtml() {
        return this.indexHtml;
    }

    public void setIndexHtml(String indexHtml) {
        this.indexHtml = indexHtml;
    }

    public RootHtmlDomNode init(HtmlDomNode.Sender send, RootTag tagTree, Cache cache) {
        try {
            return tagTree.init(this.modelClass.getConstructor(Root.class, Cache.class).newInstance(this.engine, cache), this.rootId, send);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }
}

