/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.genericsystem.reactor.RootTag;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.Attribute;
import org.genericsystem.reactor.annotations.BindAction;
import org.genericsystem.reactor.annotations.BindSelection;
import org.genericsystem.reactor.annotations.BindText;
import org.genericsystem.reactor.annotations.Children;
import org.genericsystem.reactor.annotations.CustomAnnotations;
import org.genericsystem.reactor.annotations.DirectSelect;
import org.genericsystem.reactor.annotations.ForEach;
import org.genericsystem.reactor.annotations.ForEachContext;
import org.genericsystem.reactor.annotations.InheritStyle;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.annotations.Select;
import org.genericsystem.reactor.annotations.SelectContext;
import org.genericsystem.reactor.annotations.SetStringExtractor;
import org.genericsystem.reactor.annotations.SetText;
import org.genericsystem.reactor.annotations.Step;
import org.genericsystem.reactor.annotations.Stepper;
import org.genericsystem.reactor.annotations.Stepper2;
import org.genericsystem.reactor.annotations.Style;
import org.genericsystem.reactor.annotations.StyleClass;
import org.genericsystem.reactor.annotations.Switch;
import org.genericsystem.reactor.annotations.TagName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationsManager {
    private final Set<AnnotationProcessor> processors = new LinkedHashSet<AnnotationProcessor>();
    public static final Logger log = LoggerFactory.getLogger(AnnotationsManager.class);

    public AnnotationsManager(Class<? extends RootTag> clazz) {
        this.initManager(clazz);
    }

    protected void registerCustomAnnotations(Class<? extends RootTag> clazz) {
        CustomAnnotations annotations = clazz.getAnnotation(CustomAnnotations.class);
        if (annotations != null) {
            for (Class<? extends Annotation> annotation : annotations.value()) {
                this.registerAnnotation(annotation);
            }
        }
    }

    public void initManager(Class<? extends RootTag> clazz) {
        this.registerAnnotation(Children.class);
        this.registerAnnotation(DirectSelect.class);
        this.registerAnnotation(Select.class);
        this.registerAnnotation(SelectContext.class);
        this.registerAnnotation(ForEach.class);
        this.registerAnnotation(ForEachContext.class);
        this.registerAnnotation(Stepper.class);
        this.registerAnnotation(Step.class);
        this.registerAnnotation(Stepper2.class);
        this.registerAnnotation(BindSelection.class);
        this.registerAnnotation(SetStringExtractor.class);
        this.registerAnnotation(TagName.class);
        this.registerAnnotation(StyleClass.class);
        this.registerAnnotation(Style.FlexDirectionStyle.class);
        this.registerAnnotation(Style.KeepFlexDirection.class);
        this.registerAnnotation(Style.ReverseFlexDirection.class);
        this.registerAnnotation(SetText.class);
        this.registerAnnotation(BindText.class);
        this.registerAnnotation(BindAction.class);
        this.registerAnnotation(Style.class);
        this.registerAnnotation(Style.GenericValueBackgroundColor.class);
        this.registerAnnotation(InheritStyle.class);
        this.registerAnnotation(Attribute.class);
        this.registerAnnotation(Switch.class);
        this.registerCustomAnnotations(clazz);
    }

    public void registerAnnotation(Class<? extends Annotation> annotationClass) {
        Process processAnnotation = annotationClass.getAnnotation(Process.class);
        if (processAnnotation != null) {
            try {
                this.processors.add(new AnnotationProcessor(annotationClass, processAnnotation.value().newInstance(), processAnnotation.repeatable()));
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalStateException(e);
            }
        } else {
            log.warn("Unable to find a processor on annotation: {}.", (Object)annotationClass.getSimpleName());
        }
    }

    public void processAnnotations(Tag tag) {
        for (AnnotationProcessor processor : this.processors) {
            AnnotationsManager.processAnnotation(processor, tag);
        }
    }

    static <T extends Tag> void processAnnotation(AnnotationProcessor processor, Tag tag) {
        Tag current;
        ArrayDeque classesToResult = new ArrayDeque();
        if (!processor.isRepeatable()) {
            Annotation applyingAnnotation = null;
            for (current = tag; current != null; current = current.getParent()) {
                List<Annotation> annotationsFound = AnnotationsManager.selectAnnotations(current.getClass(), processor, classesToResult, tag);
                if (!DirectSelect.class.equals(processor.getAnnotationClass())) {
                    Class<?> superClass = current.getClass().getSuperclass();
                    while (annotationsFound.isEmpty() && Tag.class.isAssignableFrom(superClass)) {
                        annotationsFound = AnnotationsManager.selectAnnotations(superClass, processor, classesToResult, tag);
                        superClass = superClass.getSuperclass();
                    }
                }
                if (!annotationsFound.isEmpty()) {
                    applyingAnnotation = annotationsFound.get(0);
                }
                classesToResult.push(current.getClass());
            }
            if (applyingAnnotation != null) {
                processor.getProcess().accept(applyingAnnotation, tag);
            }
        } else {
            ArrayList applyingAnnotations = new ArrayList();
            while (current != null) {
                Class<?> superClass = current.getClass();
                ArrayList<Annotation> annotationsFound = new ArrayList<Annotation>();
                while (Tag.class.isAssignableFrom(superClass)) {
                    annotationsFound.addAll(AnnotationsManager.selectAnnotations(superClass, processor, classesToResult, tag));
                    superClass = superClass.getSuperclass();
                }
                Collections.reverse(annotationsFound);
                applyingAnnotations.addAll(annotationsFound);
                classesToResult.push(current.getClass());
                current = current.getParent();
            }
            for (Annotation applyingAnnotation : applyingAnnotations) {
                processor.getProcess().accept(applyingAnnotation, tag);
            }
        }
    }

    public static boolean posMatches(int[] posAnnotation, Class<?>[] pathAnnotation, Tag testedTag) {
        if (posAnnotation.length == 0) {
            return true;
        }
        Tag tag = testedTag;
        for (int i = pathAnnotation.length - 1; i >= 0; --i) {
            if (tag.getParent() == null || posAnnotation[i] != -1 && AnnotationsManager.position(tag, pathAnnotation[i]) != posAnnotation[i]) {
                return false;
            }
            tag = tag.getParent();
        }
        return true;
    }

    public static int position(Tag tag, Class<?> tagClass) {
        Tag sibling;
        int result = 0;
        Iterator iterator = tag.getParent().getObservableChildren().iterator();
        while (iterator.hasNext() && !(sibling = (Tag)iterator.next()).equals(tag)) {
            if (!tagClass.isAssignableFrom(sibling.getClass())) continue;
            ++result;
        }
        return result;
    }

    static List<Annotation> selectAnnotations(Class<?> annotatedClass, AnnotationProcessor processor, Deque<Class<?>> classesToResult, Tag tag) {
        Annotation[] annotations;
        Class<? extends Annotation> annotationClass = processor.getAnnotationClass();
        ArrayList<Annotation> annotationsFound = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = annotatedClass.getAnnotationsByType(annotationClass)) {
            try {
                Class[] path = (Class[])annotation.annotationType().getDeclaredMethod("path", new Class[0]).invoke((Object)annotation, new Object[0]);
                int[] pos = (int[])annotation.annotationType().getDeclaredMethod("pos", new Class[0]).invoke((Object)annotation, new Object[0]);
                if (pos.length != 0 && pos.length != path.length) {
                    throw new IllegalStateException("The annotation " + annotationClass.getSimpleName() + " contains a path and an array of class positions of different lengths. path: " + Arrays.asList(path).stream().map(c -> c.getSimpleName()).collect(Collectors.toList()) + ", positions: " + IntStream.of(pos).boxed().collect(Collectors.toList()) + " found on class " + annotatedClass.getSimpleName());
                }
                if (!AnnotationsManager.isAssignableFrom(Arrays.asList(path), new ArrayList(classesToResult)) || !AnnotationsManager.posMatches(pos, path, tag)) continue;
                if (!annotationsFound.isEmpty() && !processor.isRepeatable()) {
                    throw new IllegalStateException("Multiple annotations applicable to same tag defined at same level. Annotation: " + annotationClass.getSimpleName() + ", path to tag: " + Arrays.asList(path).stream().map(c -> c.getSimpleName()).collect(Collectors.toList()));
                }
                annotationsFound.add(annotation);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }
        return annotationsFound;
    }

    public static boolean isAssignableFrom(List<Class<?>> list1, List<Class<?>> list2) {
        if (list1.size() != list2.size()) {
            return false;
        }
        for (int i = 0; i < list1.size(); ++i) {
            if (list1.get(i).isAssignableFrom(list2.get(i))) continue;
            return false;
        }
        return true;
    }

    public class AnnotationProcessor {
        private final Class<? extends Annotation> annotationClass;
        private final BiConsumer<Annotation, Tag> process;
        private final boolean repeatable;

        public AnnotationProcessor(Class<? extends Annotation> annotationClass, BiConsumer<Annotation, Tag> process, boolean repeatable) {
            this.annotationClass = annotationClass;
            this.process = process;
            this.repeatable = repeatable;
        }

        public Class<? extends Annotation> getAnnotationClass() {
            return this.annotationClass;
        }

        public BiConsumer<Annotation, Tag> getProcess() {
            return this.process;
        }

        public boolean isRepeatable() {
            return this.repeatable;
        }
    }
}

