/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.contextproperties;

import io.reactivex.Observable;
import java.util.function.Function;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.contextproperties.ContextProperty;

public interface TextPropertyDefaults
extends ContextProperty {
    public static final String TEXT = "text";
    public static final String TEXT_BINDING = "binding";

    default public Property<String> getDomNodeTextProperty(Context model) {
        if (!model.containsAttribute((Tag)this, TEXT)) {
            SimpleStringProperty text = new SimpleStringProperty();
            text.addListener(model.getHtmlDomNode((Tag)this).getTextListener());
            this.addContextAttribute(TEXT, model, text);
        }
        return this.getContextProperty(TEXT, model);
    }

    default public void setText(Context context, String value) {
        this.getDomNodeTextProperty(context).setValue((Object)value);
    }

    default public void setText(String value) {
        this.addPrefixBinding(context -> this.setText((Context)context, value));
    }

    default public void bindText(Context context, Observable<String> observableText) {
        this.addContextAttribute(TEXT_BINDING, context, observableText);
        context.getHtmlDomNode((Tag)this).getDisposables().add(observableText.subscribe(newText -> this.getDomNodeTextProperty(context).setValue(newText)));
    }

    default public void bindText(Function<Context, Observable<String>> applyOnModel) {
        this.addPrefixBinding(context -> this.bindText((Context)context, (Observable<String>)((Observable)applyOnModel.apply((Context)context))));
    }
}

