/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.context;

import io.reactivex.Observable;
import java.util.function.BiFunction;
import javafx.beans.property.Property;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.defaults.tools.RxJavaHelpers;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.security.model.Role;
import org.genericsystem.security.model.UserRole;

public interface TagSwitcher
extends BiFunction<Context, Tag, Observable<Boolean>> {

    public static class LOGGED_USER_ADMIN
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            Property<Generic> loggedUserProperty = tag.getLoggedUserProperty(context);
            return RxJavaHelpers.optionalValuesOf(loggedUserProperty).map(opt -> {
                if (!opt.isPresent()) {
                    return false;
                }
                Generic admin = (Generic)context.find(Role.Admin.class).getLink((DefaultGeneric)context.find(UserRole.class), (DefaultGeneric[])new Generic[]{(Generic)opt.get()});
                return admin != null;
            });
        }
    }

    public static class NO_LOGGED_USER
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            Property<Generic> loggedUserProperty = tag.getLoggedUserProperty(context);
            return RxJavaHelpers.optionalValuesOf(loggedUserProperty).map(opt -> !opt.isPresent());
        }
    }

    public static class LOGGED_USER
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            Property<Generic> loggedUserProperty = tag.getLoggedUserProperty(context);
            return RxJavaHelpers.optionalValuesOf(loggedUserProperty).map(opt -> opt.isPresent());
        }
    }

    public static class ADMIN_MODE_ONLY
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            return RxJavaHelpers.optionalValuesOf(tag.getAdminModeProperty(context)).map(opt -> opt.isPresent() && (Boolean)opt.get() != false);
        }
    }

    public static class NORMAL_MODE_ONLY
    implements TagSwitcher {
        @Override
        public Observable<Boolean> apply(Context context, Tag tag) {
            return RxJavaHelpers.optionalValuesOf(tag.getAdminModeProperty(context)).map(opt -> !opt.isPresent() || (Boolean)opt.get() == false);
        }
    }
}

