/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor.annotations;

import io.vertx.core.json.JsonObject;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.function.BiConsumer;
import org.genericsystem.api.core.TagAnnotation;
import org.genericsystem.common.Generic;
import org.genericsystem.defaults.DefaultGeneric;
import org.genericsystem.reactor.Context;
import org.genericsystem.reactor.Tag;
import org.genericsystem.reactor.annotations.GenericProcess;
import org.genericsystem.reactor.annotations.Process;
import org.genericsystem.reactor.extended.ExtendedAnnotationsManager;
import org.genericsystem.reactor.extended.ExtendedRootTag;
import org.genericsystem.reactor.gscomponents.TagImpl;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
@Process(value=StepProcessor.class)
@GenericProcess(value=StepGenericProcessor.class)
@Repeatable(value=Steps.class)
public @interface Step {
    public Class<? extends TagImpl>[] path() default {};

    public int[] pos() default {};

    public Class<? extends TagImpl> next();

    public String prevText() default "<<";

    public String nextText() default ">>";

    public static class StepGenericProcessor
    implements ExtendedAnnotationsManager.IGenericAnnotationProcessor {
        @Override
        public void setAnnotation(ExtendedRootTag.GTag gTag, Annotation annotation) {
            Step step = (Step)annotation;
            ExtendedRootTag.GTagAnnotation gTagAnnotation = (ExtendedRootTag.GTagAnnotation)gTag.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationAttribute.class), (Serializable)new TagAnnotation(Step.class, (Class[])step.path(), step.pos()), (DefaultGeneric[])new Generic[0]);
            gTagAnnotation.setHolder((DefaultGeneric)gTag.getRoot().find(ExtendedRootTag.TagType.TagAnnotationContentAttribute.class), (Serializable)((Object)new JsonObject().put("next", step.next().getName()).put("prevText", step.prevText()).put("nextText", step.nextText()).encodePrettily()), (DefaultGeneric[])new Generic[0]);
        }

        @Override
        public void onRemove(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
        }

        @Override
        public void onAdd(Tag tag, Context context, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
        }

        @Override
        public void onAdd(Tag tag, ExtendedRootTag.GTagAnnotation gTagAnnotation, ExtendedRootTag.GTagAnnotationContent annotationContent) {
            JsonObject content = gTagAnnotation.getContent().getJsonValue();
            Class<?> nextClass = null;
            try {
                nextClass = Class.forName(content.getString("next"));
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Class " + content.getString("next") + " not found");
            }
            tag.getRootTag().processStep(tag, nextClass, content.getString("prevText"), content.getString("nextText"));
        }
    }

    public static class StepProcessor
    implements BiConsumer<Annotation, Tag> {
        @Override
        public void accept(Annotation annotation, Tag tag) {
            tag.getRootTag().processStep(tag, ((Step)annotation).next(), ((Step)annotation).prevText(), ((Step)annotation).nextText());
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface Steps {
        public Step[] value();
    }
}

