/*
 * Decompiled with CFR 0.152.
 */
package org.genericsystem.reactor;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.util.StringConverter;
import javafx.util.converter.BooleanStringConverter;
import javafx.util.converter.DoubleStringConverter;
import javafx.util.converter.FloatStringConverter;
import javafx.util.converter.IntegerStringConverter;
import javafx.util.converter.LongStringConverter;
import javafx.util.converter.ShortStringConverter;
import org.genericsystem.api.core.AxedPropertyClass;
import org.genericsystem.api.core.TagAnnotation;

public class ReactorStatics {
    public static final String BACKGROUND = "background";
    public static final String CHECKED = "checked";
    public static final String DISABLED = "disabled";
    static final String MSG_TYPE = "msgType";
    static final String ADD = "A";
    static final String UPDATE = "U";
    static final String REMOVE = "R";
    static final String UPDATE_TEXT = "UT";
    static final String UPDATE_SELECTION = "US";
    static final String ADD_STYLECLASS = "AC";
    static final String REMOVE_STYLECLASS = "RC";
    static final String ADD_STYLE = "AS";
    static final String REMOVE_STYLE = "RS";
    static final String ADD_ATTRIBUTE = "AA";
    static final String REMOVE_ATTRIBUTE = "RA";
    static final String PARENT_ID = "parentId";
    public static final String ID = "nodeId";
    static final String NEXT_ID = "nextId";
    static final String STYLE_PROPERTY = "styleProperty";
    static final String STYLE_VALUE = "styleValue";
    static final String ATTRIBUTE_NAME = "attributeName";
    static final String ATTRIBUTE_VALUE = "attributeValue";
    static final String STYLECLASS = "styleClass";
    static final String TEXT_CONTENT = "textContent";
    static final String TAG_HTML = "tagHtml";
    static final String ELT_TYPE = "eltType";
    static final String SELECTED_INDEX = "selectedIndex";
    public static final Map<Class<?>, StringConverter> STRING_CONVERTERS = new LinkedHashMap<Class<?>, StringConverter>(){
        {
            this.put(AxedPropertyClass.class, new StringConverter<AxedPropertyClass>(){

                public String toString(AxedPropertyClass object) {
                    return object != null ? object.toString() : null;
                }

                public AxedPropertyClass fromString(String string) {
                    try {
                        String[] parts = string.trim().split("#");
                        return new AxedPropertyClass(Class.forName(parts[0]), Integer.parseInt(parts[1]));
                    }
                    catch (ArrayIndexOutOfBoundsException | ClassCastException | ClassNotFoundException | NumberFormatException e) {
                        throw new IllegalStateException();
                    }
                }
            });
            this.put(Boolean.class, new BooleanStringConverter());
            this.put(byte[].class, new StringConverter<byte[]>(){

                public String toString(byte[] bytes) {
                    return new String(bytes);
                }

                public byte[] fromString(String string) {
                    return string.getBytes();
                }
            });
            this.put(Double.class, new DoubleStringConverter());
            this.put(Float.class, new FloatStringConverter());
            this.put(Integer.class, new IntegerStringConverter());
            this.put(Long.class, new LongStringConverter());
            this.put(Short.class, new ShortStringConverter());
            this.put(String.class, new StringConverter<String>(){

                public String toString(String string) {
                    return string != null && !string.trim().isEmpty() ? string.trim() : null;
                }

                public String fromString(String string) {
                    return string != null && !string.trim().isEmpty() ? string.trim() : null;
                }
            });
            this.put(Class.class, new StringConverter<Class<?>>(){

                public String toString(Class<?> clazz) {
                    return clazz != null ? clazz.getName() : null;
                }

                public Class<?> fromString(String className) {
                    try {
                        return Class.forName(className.trim());
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException();
                    }
                }
            });
            this.put(TagAnnotation.class, new StringConverter<TagAnnotation>(){

                public String toString(TagAnnotation object) {
                    JsonObject result = new JsonObject();
                    result.put("annotationClass", object.getAnnotationClass().getName());
                    result.put("path", new JsonArray(Arrays.stream(object.getPath()).map(clazz -> clazz.getName()).collect(Collectors.toList())));
                    result.put("pos", new JsonArray(IntStream.of(object.getPos()).boxed().collect(Collectors.toList())));
                    result.put("name", object.getName());
                    return result.encodePrettily();
                }

                public TagAnnotation fromString(String string) {
                    JsonObject json = new JsonObject(string);
                    Class<?> annotationClass = null;
                    try {
                        annotationClass = Class.forName(json.getString("annotationClass"));
                    }
                    catch (ClassNotFoundException e) {
                        throw new IllegalStateException("Class " + json.getString("annotationClass") + " not found");
                    }
                    Class[] path = (Class[])json.getJsonArray("path").stream().map(className -> {
                        try {
                            return Class.forName((String)className);
                        }
                        catch (ClassNotFoundException e) {
                            throw new IllegalStateException("Class " + className + " not found");
                        }
                    }).toArray(Class[]::new);
                    int[] pos = json.getJsonArray("pos").stream().mapToInt(i -> (Integer)i).toArray();
                    String name = json.getString("name");
                    return new TagAnnotation(annotationClass, path, pos, name);
                }
            });
        }
    };

    public static <T> T fromString(String s) {
        byte[] data = Base64.getDecoder().decode(s);
        try {
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(data));
            Object o = ois.readObject();
            ois.close();
            return (T)o;
        }
        catch (IOException | ClassNotFoundException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String toString(Serializable o) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(o);
            oos.close();
        }
        catch (IOException e) {
            return null;
        }
        return Base64.getEncoder().encodeToString(baos.toByteArray());
    }
}

